// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl


public class UpdateFileSystemProtectionRequest private constructor(builder: Builder) {
    /**
     * The ID of the file system to update.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The status of the file system's replication overwrite protection.
     * + `ENABLED` – The file system cannot be used as the destination file system in a replication configuration. The file system is writeable. Replication overwrite protection is `ENABLED` by default.
     * + `DISABLED` – The file system can be used as the destination file system in a replication configuration. The file system is read-only and can only be modified by EFS replication.
     * + `REPLICATING` – The file system is being used as the destination file system in a replication configuration. The file system is read-only and is only modified only by EFS replication.
     *
     * If the replication configuration is deleted, the file system's replication overwrite protection is re-enabled and the file system becomes writeable.
     */
    public val replicationOverwriteProtection: aws.sdk.kotlin.services.efs.model.ReplicationOverwriteProtection? = builder.replicationOverwriteProtection

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.UpdateFileSystemProtectionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemProtectionRequest(")
        append("fileSystemId=$fileSystemId,")
        append("replicationOverwriteProtection=$replicationOverwriteProtection")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (this.replicationOverwriteProtection?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemProtectionRequest

        if (fileSystemId != other.fileSystemId) return false
        if (replicationOverwriteProtection != other.replicationOverwriteProtection) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.UpdateFileSystemProtectionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the file system to update.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The status of the file system's replication overwrite protection.
         * + `ENABLED` – The file system cannot be used as the destination file system in a replication configuration. The file system is writeable. Replication overwrite protection is `ENABLED` by default.
         * + `DISABLED` – The file system can be used as the destination file system in a replication configuration. The file system is read-only and can only be modified by EFS replication.
         * + `REPLICATING` – The file system is being used as the destination file system in a replication configuration. The file system is read-only and is only modified only by EFS replication.
         *
         * If the replication configuration is deleted, the file system's replication overwrite protection is re-enabled and the file system becomes writeable.
         */
        public var replicationOverwriteProtection: aws.sdk.kotlin.services.efs.model.ReplicationOverwriteProtection? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.UpdateFileSystemProtectionRequest) : this() {
            this.fileSystemId = x.fileSystemId
            this.replicationOverwriteProtection = x.replicationOverwriteProtection
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.UpdateFileSystemProtectionRequest = UpdateFileSystemProtectionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
