// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Required if the `RootDirectory` > `Path` specified does not exist. Specifies the POSIX IDs and permissions to apply to the access point's `RootDirectory` > `Path`. If the access point root directory does not exist, EFS creates it with these settings when a client connects to the access point. When specifying `CreationInfo`, you must include values for all properties.
 *
 * Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount using the access point will fail.
 *
 * If you do not provide `CreationInfo` and the specified `RootDirectory` does not exist, attempts to mount the file system using the access point will fail.
 */
public class CreationInfo private constructor(builder: Builder) {
    /**
     * Specifies the POSIX group ID to apply to the `RootDirectory`. Accepts values from 0 to 2^32 (4294967295).
     */
    public val ownerGid: kotlin.Long = requireNotNull(builder.ownerGid) { "A non-null value must be provided for ownerGid" }
    /**
     * Specifies the POSIX user ID to apply to the `RootDirectory`. Accepts values from 0 to 2^32 (4294967295).
     */
    public val ownerUid: kotlin.Long = requireNotNull(builder.ownerUid) { "A non-null value must be provided for ownerUid" }
    /**
     * Specifies the POSIX permissions to apply to the `RootDirectory`, in the format of an octal number representing the file's mode bits.
     */
    public val permissions: kotlin.String = requireNotNull(builder.permissions) { "A non-null value must be provided for permissions" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreationInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreationInfo(")
        append("ownerGid=$ownerGid,")
        append("ownerUid=$ownerUid,")
        append("permissions=$permissions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ownerGid.hashCode()
        result = 31 * result + (this.ownerUid.hashCode())
        result = 31 * result + (this.permissions.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreationInfo

        if (ownerGid != other.ownerGid) return false
        if (ownerUid != other.ownerUid) return false
        if (permissions != other.permissions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreationInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the POSIX group ID to apply to the `RootDirectory`. Accepts values from 0 to 2^32 (4294967295).
         */
        public var ownerGid: kotlin.Long? = null
        /**
         * Specifies the POSIX user ID to apply to the `RootDirectory`. Accepts values from 0 to 2^32 (4294967295).
         */
        public var ownerUid: kotlin.Long? = null
        /**
         * Specifies the POSIX permissions to apply to the `RootDirectory`, in the format of an octal number representing the file's mode bits.
         */
        public var permissions: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreationInfo) : this() {
            this.ownerGid = x.ownerGid
            this.ownerUid = x.ownerUid
            this.permissions = x.permissions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreationInfo = CreationInfo(this)

        internal fun correctErrors(): Builder {
            if (ownerGid == null) ownerGid = 0L
            if (ownerUid == null) ownerUid = 0L
            if (permissions == null) permissions = ""
            return this
        }
    }
}
