// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl


public class PutFileSystemPolicyRequest private constructor(builder: Builder) {
    /**
     * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check. The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future `PutFileSystemPolicy` requests on this file system. Set `BypassPolicyLockoutSafetyCheck` to `True` only when you intend to prevent the IAM principal that is making the request from making subsequent `PutFileSystemPolicy` requests on this file system. The default value is `False`.
     */
    public val bypassPolicyLockoutSafetyCheck: kotlin.Boolean? = builder.bypassPolicyLockoutSafetyCheck
    /**
     * The ID of the EFS file system that you want to create or update the `FileSystemPolicy` for.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The `FileSystemPolicy` that you're creating. Accepts a JSON formatted policy definition. EFS file system policies have a 20,000 character limit. To find out more about the elements that make up a file system policy, see [Resource-based policies within Amazon EFS](https://docs.aws.amazon.com/efs/latest/ug/security_iam_service-with-iam.html#security_iam_service-with-iam-resource-based-policies).
     */
    public val policy: kotlin.String? = builder.policy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutFileSystemPolicyRequest(")
        append("bypassPolicyLockoutSafetyCheck=$bypassPolicyLockoutSafetyCheck,")
        append("fileSystemId=$fileSystemId,")
        append("policy=$policy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bypassPolicyLockoutSafetyCheck?.hashCode() ?: 0
        result = 31 * result + (this.fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (this.policy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutFileSystemPolicyRequest

        if (bypassPolicyLockoutSafetyCheck != other.bypassPolicyLockoutSafetyCheck) return false
        if (fileSystemId != other.fileSystemId) return false
        if (policy != other.policy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * (Optional) A boolean that specifies whether or not to bypass the `FileSystemPolicy` lockout safety check. The lockout safety check determines whether the policy in the request will lock out, or prevent, the IAM principal that is making the request from making future `PutFileSystemPolicy` requests on this file system. Set `BypassPolicyLockoutSafetyCheck` to `True` only when you intend to prevent the IAM principal that is making the request from making subsequent `PutFileSystemPolicy` requests on this file system. The default value is `False`.
         */
        public var bypassPolicyLockoutSafetyCheck: kotlin.Boolean? = null
        /**
         * The ID of the EFS file system that you want to create or update the `FileSystemPolicy` for.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The `FileSystemPolicy` that you're creating. Accepts a JSON formatted policy definition. EFS file system policies have a 20,000 character limit. To find out more about the elements that make up a file system policy, see [Resource-based policies within Amazon EFS](https://docs.aws.amazon.com/efs/latest/ug/security_iam_service-with-iam.html#security_iam_service-with-iam-resource-based-policies).
         */
        public var policy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyRequest) : this() {
            this.bypassPolicyLockoutSafetyCheck = x.bypassPolicyLockoutSafetyCheck
            this.fileSystemId = x.fileSystemId
            this.policy = x.policy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyRequest = PutFileSystemPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
