// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesEfsModelPosixUserDslBuilderRef = aws.sdk.kotlin.services.efs.model.PosixUser
private val awsSdkKotlinServicesEfsModelRootDirectoryDslBuilderRef = aws.sdk.kotlin.services.efs.model.RootDirectory

public class CreateAccessPointRequest private constructor(builder: Builder) {
    /**
     * A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ID of the EFS file system that the access point provides access to.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The operating system user and group applied to all file system requests made using the access point.
     */
    public val posixUser: aws.sdk.kotlin.services.efs.model.PosixUser? = builder.posixUser
    /**
     * Specifies the directory on the EFS file system that the access point exposes as the root directory of your file system to NFS clients using the access point. The clients using the access point can only access the root directory and below. If the `RootDirectory` > `Path` specified does not exist, Amazon EFS creates it and applies the `CreationInfo` settings when a client connects to an access point. When specifying a `RootDirectory`, you must provide the `Path`, and the `CreationInfo`.
     *
     * Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount using the access point will fail.
     */
    public val rootDirectory: aws.sdk.kotlin.services.efs.model.RootDirectory? = builder.rootDirectory
    /**
     * Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateAccessPointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessPointRequest(")
        append("clientToken=$clientToken,")
        append("fileSystemId=$fileSystemId,")
        append("posixUser=$posixUser,")
        append("rootDirectory=$rootDirectory,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (this.fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (this.posixUser?.hashCode() ?: 0)
        result = 31 * result + (this.rootDirectory?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessPointRequest

        if (clientToken != other.clientToken) return false
        if (fileSystemId != other.fileSystemId) return false
        if (posixUser != other.posixUser) return false
        if (rootDirectory != other.rootDirectory) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateAccessPointRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent creation.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ID of the EFS file system that the access point provides access to.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The operating system user and group applied to all file system requests made using the access point.
         */
        public var posixUser: aws.sdk.kotlin.services.efs.model.PosixUser? = null
        /**
         * Specifies the directory on the EFS file system that the access point exposes as the root directory of your file system to NFS clients using the access point. The clients using the access point can only access the root directory and below. If the `RootDirectory` > `Path` specified does not exist, Amazon EFS creates it and applies the `CreationInfo` settings when a client connects to an access point. When specifying a `RootDirectory`, you must provide the `Path`, and the `CreationInfo`.
         *
         * Amazon EFS creates a root directory only if you have provided the CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you do not provide this information, Amazon EFS does not create the root directory. If the root directory does not exist, attempts to mount using the access point will fail.
         */
        public var rootDirectory: aws.sdk.kotlin.services.efs.model.RootDirectory? = null
        /**
         * Creates tags associated with the access point. Each tag is a key-value pair, each key must be unique. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateAccessPointRequest) : this() {
            this.clientToken = x.clientToken
            this.fileSystemId = x.fileSystemId
            this.posixUser = x.posixUser
            this.rootDirectory = x.rootDirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateAccessPointRequest = CreateAccessPointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.efs.model.PosixUser] inside the given [block]
         */
        public fun posixUser(block: aws.sdk.kotlin.services.efs.model.PosixUser.Builder.() -> kotlin.Unit) {
            this.posixUser = awsSdkKotlinServicesEfsModelPosixUserDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.efs.model.RootDirectory] inside the given [block]
         */
        public fun rootDirectory(block: aws.sdk.kotlin.services.efs.model.RootDirectory.Builder.() -> kotlin.Unit) {
            this.rootDirectory = awsSdkKotlinServicesEfsModelRootDirectoryDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
