// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.DescribeLifecycleConfigurationResponse
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.sdk.kotlin.services.efs.model.LifecyclePolicy
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeLifecycleConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<DescribeLifecycleConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeLifecycleConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeLifecycleConfigurationError(context, call, payload)
        }
        val builder = DescribeLifecycleConfigurationResponse.Builder()

        if (payload != null) {
            deserializeDescribeLifecycleConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeLifecycleConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall, payload)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLifecycleConfigurationOperationBody(builder: DescribeLifecycleConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLEPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LifecyclePolicies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLEPOLICIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLEPOLICIES_DESCRIPTOR.index -> builder.lifecyclePolicies =
                    deserializer.deserializeList(LIFECYCLEPOLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<LifecyclePolicy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLifecyclePolicyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
