// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * The backup policy for the file system used to create automatic daily backups. If status has a value of `ENABLED`, the file system is being automatically backed up. For more information, see [Automatic backups](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups).
 */
public class BackupPolicy private constructor(builder: Builder) {
    /**
     * Describes the status of the file system's backup policy.
     * + **`ENABLED`** – EFS is automatically backing up the file system.
     * + **`ENABLING`** – EFS is turning on automatic backups for the file system.
     * + **`DISABLED`** – Automatic back ups are turned off for the file system.
     * + **`DISABLING`** – EFS is turning off automatic backups for the file system.
     */
    public val status: aws.sdk.kotlin.services.efs.model.Status = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.BackupPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BackupPolicy(")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BackupPolicy

        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.BackupPolicy = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Describes the status of the file system's backup policy.
         * + **`ENABLED`** – EFS is automatically backing up the file system.
         * + **`ENABLING`** – EFS is turning on automatic backups for the file system.
         * + **`DISABLED`** – Automatic back ups are turned off for the file system.
         * + **`DISABLING`** – EFS is turning off automatic backups for the file system.
         */
        public var status: aws.sdk.kotlin.services.efs.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.BackupPolicy) : this() {
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.BackupPolicy = BackupPolicy(this)

        internal fun correctErrors(): Builder {
            if (status == null) status = Status.SdkUnknown("no value provided")
            return this
        }
    }
}
