// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Returned if there's not enough capacity to provision additional throughput. This value might be returned when you try to create a file system in provisioned throughput mode, when you attempt to increase the provisioned throughput of an existing file system, or when you attempt to change an existing file system from Bursting Throughput to Provisioned Throughput mode. Try again later.
 */
public class InsufficientThroughputCapacity private constructor(builder: Builder) : EfsException(builder.message) {

    /**
     * The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type.
     */
    public val errorCode: kotlin.String = requireNotNull(builder.errorCode) { "A non-null value must be provided for errorCode" }

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Server
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.InsufficientThroughputCapacity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InsufficientThroughputCapacity(")
        append("errorCode=$errorCode,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode.hashCode()
        result = 31 * result + (this.message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InsufficientThroughputCapacity

        if (errorCode != other.errorCode) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.InsufficientThroughputCapacity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.InsufficientThroughputCapacity) : this() {
            this.errorCode = x.errorCode
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.InsufficientThroughputCapacity = InsufficientThroughputCapacity(this)

        internal fun correctErrors(): Builder {
            if (errorCode == null) errorCode = ""
            return this
        }
    }
}
