// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the destination file system in the replication configuration.
 */
public class Destination private constructor(builder: Builder) {
    /**
     * The ID of the destination Amazon EFS file system.
     */
    public val fileSystemId: kotlin.String = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }
    /**
     * The time when the most recent sync was successfully completed on the destination file system. Any changes to data on the source file system that occurred before this time have been successfully replicated to the destination file system. Any changes that occurred after this time might not be fully replicated.
     */
    public val lastReplicatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastReplicatedTimestamp
    /**
     * ID of the Amazon Web Services account in which the destination file system resides.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The Amazon Web Services Region in which the destination file system is located.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }
    /**
     * Amazon Resource Name (ARN) of the IAM role in the source account that allows Amazon EFS to perform replication on its behalf. This is optional for same-account replication and required for cross-account replication.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Describes the status of the replication configuration. For more information about replication status, see [Viewing replication details](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html) in the *Amazon EFS User Guide*.
     */
    public val status: aws.sdk.kotlin.services.efs.model.ReplicationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Message that provides details about the `PAUSED` or `ERRROR` state of the replication destination configuration. For more information about replication status messages, see [Viewing replication details](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html) in the *Amazon EFS User Guide*.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("fileSystemId=$fileSystemId,")
        append("lastReplicatedTimestamp=$lastReplicatedTimestamp,")
        append("ownerId=$ownerId,")
        append("region=$region,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId.hashCode()
        result = 31 * result + (this.lastReplicatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (this.ownerId?.hashCode() ?: 0)
        result = 31 * result + (this.region.hashCode())
        result = 31 * result + (this.roleArn?.hashCode() ?: 0)
        result = 31 * result + (this.status.hashCode())
        result = 31 * result + (this.statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (fileSystemId != other.fileSystemId) return false
        if (lastReplicatedTimestamp != other.lastReplicatedTimestamp) return false
        if (ownerId != other.ownerId) return false
        if (region != other.region) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the destination Amazon EFS file system.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The time when the most recent sync was successfully completed on the destination file system. Any changes to data on the source file system that occurred before this time have been successfully replicated to the destination file system. Any changes that occurred after this time might not be fully replicated.
         */
        public var lastReplicatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * ID of the Amazon Web Services account in which the destination file system resides.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The Amazon Web Services Region in which the destination file system is located.
         */
        public var region: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of the IAM role in the source account that allows Amazon EFS to perform replication on its behalf. This is optional for same-account replication and required for cross-account replication.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Describes the status of the replication configuration. For more information about replication status, see [Viewing replication details](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html) in the *Amazon EFS User Guide*.
         */
        public var status: aws.sdk.kotlin.services.efs.model.ReplicationStatus? = null
        /**
         * Message that provides details about the `PAUSED` or `ERRROR` state of the replication destination configuration. For more information about replication status messages, see [Viewing replication details](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html) in the *Amazon EFS User Guide*.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.Destination) : this() {
            this.fileSystemId = x.fileSystemId
            this.lastReplicatedTimestamp = x.lastReplicatedTimestamp
            this.ownerId = x.ownerId
            this.region = x.region
            this.roleArn = x.roleArn
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.Destination = Destination(this)

        internal fun correctErrors(): Builder {
            if (fileSystemId == null) fileSystemId = ""
            if (region == null) region = ""
            if (status == null) status = ReplicationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
