// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateFileSystemRequest private constructor(builder: Builder) {
    /**
     * The ID of the file system that you want to update.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * (Optional) The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating. Required if `ThroughputMode` is set to `provisioned`. Valid values are 1-3414 MiBps, with the upper limit depending on Region. To increase this limit, contact Amazon Web ServicesSupport. For more information, see [Amazon EFS quotas that you can increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the *Amazon EFS User Guide*.
     */
    public val provisionedThroughputInMibPs: kotlin.Double? = builder.provisionedThroughputInMibPs
    /**
     * (Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`.
     */
    public val throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = builder.throughputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemRequest(")
        append("fileSystemId=$fileSystemId,")
        append("provisionedThroughputInMibPs=$provisionedThroughputInMibPs,")
        append("throughputMode=$throughputMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (this.provisionedThroughputInMibPs?.hashCode() ?: 0)
        result = 31 * result + (this.throughputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemRequest

        if (fileSystemId != other.fileSystemId) return false
        if (!(provisionedThroughputInMibPs?.equals(other.provisionedThroughputInMibPs) ?: (other.provisionedThroughputInMibPs == null))) return false
        if (throughputMode != other.throughputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the file system that you want to update.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * (Optional) The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating. Required if `ThroughputMode` is set to `provisioned`. Valid values are 1-3414 MiBps, with the upper limit depending on Region. To increase this limit, contact Amazon Web ServicesSupport. For more information, see [Amazon EFS quotas that you can increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the *Amazon EFS User Guide*.
         */
        public var provisionedThroughputInMibPs: kotlin.Double? = null
        /**
         * (Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`.
         */
        public var throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest) : this() {
            this.fileSystemId = x.fileSystemId
            this.provisionedThroughputInMibPs = x.provisionedThroughputInMibPs
            this.throughputMode = x.throughputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest = UpdateFileSystemRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
