// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.CreateReplicationConfigurationResponse
import aws.sdk.kotlin.services.efs.model.Destination
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class CreateReplicationConfigurationOperationDeserializer: HttpDeserializer.NonStreaming<CreateReplicationConfigurationResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateReplicationConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateReplicationConfigurationError(context, call, payload)
        }
        val builder = CreateReplicationConfigurationResponse.Builder()

        if (payload != null) {
            deserializeCreateReplicationConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateReplicationConfigurationError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileSystemLimitExceeded" -> FileSystemLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "IncorrectFileSystemLifeCycleState" -> IncorrectFileSystemLifeCycleStateDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientThroughputCapacity" -> InsufficientThroughputCapacityDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "ReplicationNotFound" -> ReplicationNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "ThroughputLimitExceeded" -> ThroughputLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedAvailabilityZone" -> UnsupportedAvailabilityZoneDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateReplicationConfigurationOperationBody(builder: CreateReplicationConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Destinations"))
    val ORIGINALSOURCEFILESYSTEMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginalSourceFileSystemArn"))
    val SOURCEFILESYSTEMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceFileSystemArn"))
    val SOURCEFILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceFileSystemId"))
    val SOURCEFILESYSTEMOWNERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceFileSystemOwnerId"))
    val SOURCEFILESYSTEMREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceFileSystemRegion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(ORIGINALSOURCEFILESYSTEMARN_DESCRIPTOR)
        field(SOURCEFILESYSTEMARN_DESCRIPTOR)
        field(SOURCEFILESYSTEMID_DESCRIPTOR)
        field(SOURCEFILESYSTEMOWNERID_DESCRIPTOR)
        field(SOURCEFILESYSTEMREGION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                DESTINATIONS_DESCRIPTOR.index -> builder.destinations =
                    deserializer.deserializeList(DESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Destination>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDestinationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ORIGINALSOURCEFILESYSTEMARN_DESCRIPTOR.index -> builder.originalSourceFileSystemArn = deserializeString()
                SOURCEFILESYSTEMARN_DESCRIPTOR.index -> builder.sourceFileSystemArn = deserializeString()
                SOURCEFILESYSTEMID_DESCRIPTOR.index -> builder.sourceFileSystemId = deserializeString()
                SOURCEFILESYSTEMOWNERID_DESCRIPTOR.index -> builder.sourceFileSystemOwnerId = deserializeString()
                SOURCEFILESYSTEMREGION_DESCRIPTOR.index -> builder.sourceFileSystemRegion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
