// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteReplicationConfigurationRequest private constructor(builder: Builder) {
    /**
     * When replicating across Amazon Web Services accounts or across Amazon Web Services Regions, Amazon EFS deletes the replication configuration from both the source and destination account or Region (`ALL_CONFIGURATIONS`) by default. If there's a configuration or permissions issue that prevents Amazon EFS from deleting the replication configuration from both sides, you can use the `LOCAL_CONFIGURATION_ONLY` mode to delete the replication configuration from only the local side (the account or Region from which the delete is performed).
     *
     * Only use the `LOCAL_CONFIGURATION_ONLY` mode in the case that Amazon EFS is unable to delete the replication configuration in both the source and destination account or Region. Deleting the local configuration leaves the configuration in the other account or Region unrecoverable.
     *
     * Additionally, do not use this mode for same-account, same-region replication as doing so results in a BadRequest exception error.
     */
    public val deletionMode: aws.sdk.kotlin.services.efs.model.DeletionMode? = builder.deletionMode
    /**
     * The ID of the source file system in the replication configuration.
     */
    public val sourceFileSystemId: kotlin.String? = builder.sourceFileSystemId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.DeleteReplicationConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteReplicationConfigurationRequest(")
        append("deletionMode=$deletionMode,")
        append("sourceFileSystemId=$sourceFileSystemId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionMode?.hashCode() ?: 0
        result = 31 * result + (sourceFileSystemId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteReplicationConfigurationRequest

        if (deletionMode != other.deletionMode) return false
        if (sourceFileSystemId != other.sourceFileSystemId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.DeleteReplicationConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When replicating across Amazon Web Services accounts or across Amazon Web Services Regions, Amazon EFS deletes the replication configuration from both the source and destination account or Region (`ALL_CONFIGURATIONS`) by default. If there's a configuration or permissions issue that prevents Amazon EFS from deleting the replication configuration from both sides, you can use the `LOCAL_CONFIGURATION_ONLY` mode to delete the replication configuration from only the local side (the account or Region from which the delete is performed).
         *
         * Only use the `LOCAL_CONFIGURATION_ONLY` mode in the case that Amazon EFS is unable to delete the replication configuration in both the source and destination account or Region. Deleting the local configuration leaves the configuration in the other account or Region unrecoverable.
         *
         * Additionally, do not use this mode for same-account, same-region replication as doing so results in a BadRequest exception error.
         */
        public var deletionMode: aws.sdk.kotlin.services.efs.model.DeletionMode? = null
        /**
         * The ID of the source file system in the replication configuration.
         */
        public var sourceFileSystemId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.DeleteReplicationConfigurationRequest) : this() {
            this.deletionMode = x.deletionMode
            this.sourceFileSystemId = x.sourceFileSystemId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.DeleteReplicationConfigurationRequest = DeleteReplicationConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
