// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon Web Services Region.
 */
public class ResourceIdPreference private constructor(builder: Builder) {
    /**
     * Identifies the EFS resource ID preference, either `LONG_ID` (17 characters) or `SHORT_ID` (8 characters).
     */
    public val resourceIdType: aws.sdk.kotlin.services.efs.model.ResourceIdType? = builder.resourceIdType
    /**
     * Identifies the Amazon EFS resources to which the ID preference setting applies, `FILE_SYSTEM` and `MOUNT_TARGET`.
     */
    public val resources: List<Resource>? = builder.resources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.ResourceIdPreference = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceIdPreference(")
        append("resourceIdType=$resourceIdType,")
        append("resources=$resources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceIdType?.hashCode() ?: 0
        result = 31 * result + (resources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceIdPreference

        if (resourceIdType != other.resourceIdType) return false
        if (resources != other.resources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.ResourceIdPreference = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Identifies the EFS resource ID preference, either `LONG_ID` (17 characters) or `SHORT_ID` (8 characters).
         */
        public var resourceIdType: aws.sdk.kotlin.services.efs.model.ResourceIdType? = null
        /**
         * Identifies the Amazon EFS resources to which the ID preference setting applies, `FILE_SYSTEM` and `MOUNT_TARGET`.
         */
        public var resources: List<Resource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.ResourceIdPreference) : this() {
            this.resourceIdType = x.resourceIdType
            this.resources = x.resources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.ResourceIdPreference = ResourceIdPreference(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
