// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 *
 */
public class CreateMountTargetRequest private constructor(builder: Builder) {
    /**
     * The ID of the file system for which to create the mount target.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * If the IP address type for the mount target is IPv4, then specify the IPv4 address within the address range of the specified subnet.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Specify the type of IP address of the mount target you are creating. Options are IPv4, dual stack, or IPv6. If you don’t specify an IpAddressType, then IPv4 is used.
     * + IPV4_ONLY – Create mount target with IPv4 only subnet or dual-stack subnet.
     * + DUAL_STACK – Create mount target with dual-stack subnet.
     * + IPV6_ONLY – Create mount target with IPv6 only subnet.
     *
     * Creating IPv6 mount target only ENI in dual-stack subnet is not supported.
     */
    public val ipAddressType: aws.sdk.kotlin.services.efs.model.IpAddressType? = builder.ipAddressType
    /**
     * If the IP address type for the mount target is IPv6, then specify the IPv6 address within the address range of the specified subnet.
     */
    public val ipv6Address: kotlin.String? = builder.ipv6Address
    /**
     * VPC security group IDs, of the form `sg-xxxxxxxx`. These must be for the same VPC as the subnet specified. The maximum number of security groups depends on account quota. For more information, see [Amazon VPC Quotas](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html) in the *Amazon VPC User Guide* (see the **Security Groups** table).
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The ID of the subnet to add the mount target in. For One Zone file systems, use the subnet that is associated with the file system's Availability Zone.
     */
    public val subnetId: kotlin.String? = builder.subnetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateMountTargetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMountTargetRequest(")
        append("fileSystemId=$fileSystemId,")
        append("ipAddress=$ipAddress,")
        append("ipAddressType=$ipAddressType,")
        append("ipv6Address=$ipv6Address,")
        append("securityGroups=$securityGroups,")
        append("subnetId=$subnetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (ipv6Address?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMountTargetRequest

        if (fileSystemId != other.fileSystemId) return false
        if (ipAddress != other.ipAddress) return false
        if (ipAddressType != other.ipAddressType) return false
        if (ipv6Address != other.ipv6Address) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetId != other.subnetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateMountTargetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the file system for which to create the mount target.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * If the IP address type for the mount target is IPv4, then specify the IPv4 address within the address range of the specified subnet.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * Specify the type of IP address of the mount target you are creating. Options are IPv4, dual stack, or IPv6. If you don’t specify an IpAddressType, then IPv4 is used.
         * + IPV4_ONLY – Create mount target with IPv4 only subnet or dual-stack subnet.
         * + DUAL_STACK – Create mount target with dual-stack subnet.
         * + IPV6_ONLY – Create mount target with IPv6 only subnet.
         *
         * Creating IPv6 mount target only ENI in dual-stack subnet is not supported.
         */
        public var ipAddressType: aws.sdk.kotlin.services.efs.model.IpAddressType? = null
        /**
         * If the IP address type for the mount target is IPv6, then specify the IPv6 address within the address range of the specified subnet.
         */
        public var ipv6Address: kotlin.String? = null
        /**
         * VPC security group IDs, of the form `sg-xxxxxxxx`. These must be for the same VPC as the subnet specified. The maximum number of security groups depends on account quota. For more information, see [Amazon VPC Quotas](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html) in the *Amazon VPC User Guide* (see the **Security Groups** table).
         */
        public var securityGroups: List<String>? = null
        /**
         * The ID of the subnet to add the mount target in. For One Zone file systems, use the subnet that is associated with the file system's Availability Zone.
         */
        public var subnetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateMountTargetRequest) : this() {
            this.fileSystemId = x.fileSystemId
            this.ipAddress = x.ipAddress
            this.ipAddressType = x.ipAddressType
            this.ipv6Address = x.ipv6Address
            this.securityGroups = x.securityGroups
            this.subnetId = x.subnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateMountTargetRequest = CreateMountTargetRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
