// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.efs.auth.DefaultEfsAuthSchemeProvider
import aws.sdk.kotlin.services.efs.auth.EfsAuthSchemeProvider
import aws.sdk.kotlin.services.efs.endpoints.DefaultEfsEndpointProvider
import aws.sdk.kotlin.services.efs.endpoints.EfsEndpointParameters
import aws.sdk.kotlin.services.efs.endpoints.EfsEndpointProvider
import aws.sdk.kotlin.services.efs.model.CreateAccessPointRequest
import aws.sdk.kotlin.services.efs.model.CreateAccessPointResponse
import aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest
import aws.sdk.kotlin.services.efs.model.CreateFileSystemResponse
import aws.sdk.kotlin.services.efs.model.CreateMountTargetRequest
import aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse
import aws.sdk.kotlin.services.efs.model.CreateReplicationConfigurationRequest
import aws.sdk.kotlin.services.efs.model.CreateReplicationConfigurationResponse
import aws.sdk.kotlin.services.efs.model.CreateTagsRequest
import aws.sdk.kotlin.services.efs.model.CreateTagsResponse
import aws.sdk.kotlin.services.efs.model.DeleteAccessPointRequest
import aws.sdk.kotlin.services.efs.model.DeleteAccessPointResponse
import aws.sdk.kotlin.services.efs.model.DeleteFileSystemPolicyRequest
import aws.sdk.kotlin.services.efs.model.DeleteFileSystemPolicyResponse
import aws.sdk.kotlin.services.efs.model.DeleteFileSystemRequest
import aws.sdk.kotlin.services.efs.model.DeleteFileSystemResponse
import aws.sdk.kotlin.services.efs.model.DeleteMountTargetRequest
import aws.sdk.kotlin.services.efs.model.DeleteMountTargetResponse
import aws.sdk.kotlin.services.efs.model.DeleteReplicationConfigurationRequest
import aws.sdk.kotlin.services.efs.model.DeleteReplicationConfigurationResponse
import aws.sdk.kotlin.services.efs.model.DeleteTagsRequest
import aws.sdk.kotlin.services.efs.model.DeleteTagsResponse
import aws.sdk.kotlin.services.efs.model.DescribeAccessPointsRequest
import aws.sdk.kotlin.services.efs.model.DescribeAccessPointsResponse
import aws.sdk.kotlin.services.efs.model.DescribeAccountPreferencesRequest
import aws.sdk.kotlin.services.efs.model.DescribeAccountPreferencesResponse
import aws.sdk.kotlin.services.efs.model.DescribeBackupPolicyRequest
import aws.sdk.kotlin.services.efs.model.DescribeBackupPolicyResponse
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemPolicyRequest
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemPolicyResponse
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemsRequest
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemsResponse
import aws.sdk.kotlin.services.efs.model.DescribeLifecycleConfigurationRequest
import aws.sdk.kotlin.services.efs.model.DescribeLifecycleConfigurationResponse
import aws.sdk.kotlin.services.efs.model.DescribeMountTargetSecurityGroupsRequest
import aws.sdk.kotlin.services.efs.model.DescribeMountTargetSecurityGroupsResponse
import aws.sdk.kotlin.services.efs.model.DescribeMountTargetsRequest
import aws.sdk.kotlin.services.efs.model.DescribeMountTargetsResponse
import aws.sdk.kotlin.services.efs.model.DescribeReplicationConfigurationsRequest
import aws.sdk.kotlin.services.efs.model.DescribeReplicationConfigurationsResponse
import aws.sdk.kotlin.services.efs.model.DescribeTagsRequest
import aws.sdk.kotlin.services.efs.model.DescribeTagsResponse
import aws.sdk.kotlin.services.efs.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.efs.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.efs.model.ModifyMountTargetSecurityGroupsRequest
import aws.sdk.kotlin.services.efs.model.ModifyMountTargetSecurityGroupsResponse
import aws.sdk.kotlin.services.efs.model.PutAccountPreferencesRequest
import aws.sdk.kotlin.services.efs.model.PutAccountPreferencesResponse
import aws.sdk.kotlin.services.efs.model.PutBackupPolicyRequest
import aws.sdk.kotlin.services.efs.model.PutBackupPolicyResponse
import aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyRequest
import aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyResponse
import aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest
import aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationResponse
import aws.sdk.kotlin.services.efs.model.TagResourceRequest
import aws.sdk.kotlin.services.efs.model.TagResourceResponse
import aws.sdk.kotlin.services.efs.model.UntagResourceRequest
import aws.sdk.kotlin.services.efs.model.UntagResourceResponse
import aws.sdk.kotlin.services.efs.model.UpdateFileSystemProtectionRequest
import aws.sdk.kotlin.services.efs.model.UpdateFileSystemProtectionResponse
import aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest
import aws.sdk.kotlin.services.efs.model.UpdateFileSystemResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "EFS"
public const val SdkVersion: String = "1.5.15"
public const val ServiceApiVersion: String = "2015-02-01"

/**
 * # Amazon Elastic File System
 * Amazon Elastic File System (Amazon EFS) provides simple, scalable file storage for use with Amazon EC2 Linux and Mac instances in the Amazon Web Services Cloud. With Amazon EFS, storage capacity is elastic, growing and shrinking automatically as you add and remove files, so that your applications have the storage they need, when they need it. For more information, see the [Amazon Elastic File System API Reference](https://docs.aws.amazon.com/efs/latest/ug/api-reference.html) and the [Amazon Elastic File System User Guide](https://docs.aws.amazon.com/efs/latest/ug/whatisefs.html).
 */
public interface EfsClient : SdkClient {
    /**
     * EfsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, EfsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Efs",
                "EFS",
                "efs",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, EfsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): EfsClient = DefaultEfsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EfsEndpointProvider = builder.endpointProvider ?: DefaultEfsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: EfsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultEfsAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "EFS"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EfsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: EfsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point. The operating system user and group override any identity information provided by the NFS client. The file system path is exposed as the access point's root directory. Applications using the access point can only access data in the application's own directory and any subdirectories. A file system can have a maximum of 10,000 access points unless you request an increase. To learn more, see [Mounting a file system using EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html).
     *
     * If multiple requests to create access points on the same file system are sent in quick succession, and the file system is near the limit of access points, you may experience a throttling response for these requests. This is to ensure that the file system does not exceed the stated access point limit.
     *
     * This operation requires permissions for the `elasticfilesystem:CreateAccessPoint` action.
     *
     * Access points can be tagged on creation. If tags are specified in the creation action, IAM performs additional authorization on the `elasticfilesystem:TagResource` action to verify if users have permissions to create tags. Therefore, you must grant explicit permissions to use the `elasticfilesystem:TagResource` action. For more information, see [Granting permissions to tag resources during creation](https://docs.aws.amazon.com/efs/latest/ug/using-tags-efs.html#supported-iam-actions-tagging.html).
     */
    public suspend fun createAccessPoint(input: CreateAccessPointRequest): CreateAccessPointResponse

    /**
     * Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does not currently exist that is owned by the caller's Amazon Web Services account with the specified creation token, this operation does the following:
     * + Creates a new, empty file system. The file system will have an Amazon EFS assigned ID, and an initial lifecycle state `creating`.
     * + Returns with the description of the created file system.
     *
     * Otherwise, this operation returns a `FileSystemAlreadyExists` error with the ID of the existing file system.
     *
     * For basic use cases, you can use a randomly generated UUID for the creation token.
     *
     * The idempotent operation allows you to retry a `CreateFileSystem` call without risk of creating an extra file system. This can happen when an initial call fails in a way that leaves it uncertain whether or not a file system was actually created. An example might be that a transport level timeout occurred or your connection was reset. As long as you use the same creation token, if the initial call had succeeded in creating a file system, the client can learn of its existence from the `FileSystemAlreadyExists` error.
     *
     * For more information, see [Creating a file system](https://docs.aws.amazon.com/efs/latest/ug/creating-using-create-fs.html#creating-using-create-fs-part1) in the *Amazon EFS User Guide*.
     *
     * The `CreateFileSystem` call returns while the file system's lifecycle state is still `creating`. You can check the file system creation status by calling the DescribeFileSystems operation, which among other things returns the file system state.
     *
     * This operation accepts an optional `PerformanceMode` parameter that you choose for your file system. We recommend `generalPurpose``PerformanceMode` for all file systems. The `maxIO` mode is a previous generation performance type that is designed for highly parallelized workloads that can tolerate higher latencies than the `generalPurpose` mode. `MaxIO` mode is not supported for One Zone file systems or file systems that use Elastic throughput.
     *
     * The `PerformanceMode` can't be changed after the file system has been created. For more information, see [Amazon EFS performance modes](https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html).
     *
     * You can set the throughput mode for the file system using the `ThroughputMode` parameter.
     *
     * After the file system is fully created, Amazon EFS sets its lifecycle state to `available`, at which point you can create one or more mount targets for the file system in your VPC. For more information, see CreateMountTarget. You mount your Amazon EFS file system on an EC2 instances in your VPC by using the mount target. For more information, see [Amazon EFS: How it Works](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
     *
     * This operation requires permissions for the `elasticfilesystem:CreateFileSystem` action.
     *
     * File systems can be tagged on creation. If tags are specified in the creation action, IAM performs additional authorization on the `elasticfilesystem:TagResource` action to verify if users have permissions to create tags. Therefore, you must grant explicit permissions to use the `elasticfilesystem:TagResource` action. For more information, see [Granting permissions to tag resources during creation](https://docs.aws.amazon.com/efs/latest/ug/using-tags-efs.html#supported-iam-actions-tagging.html).
     */
    public suspend fun createFileSystem(input: CreateFileSystemRequest): CreateFileSystemResponse

    /**
     * Creates a mount target for a file system. You can then mount the file system on EC2 instances by using the mount target.
     *
     * You can create one mount target in each Availability Zone in your VPC. All EC2 instances in a VPC within a given Availability Zone share a single mount target for a given file system. If you have multiple subnets in an Availability Zone, you create a mount target in one of the subnets. EC2 instances do not need to be in the same subnet as the mount target in order to access their file system.
     *
     * You can create only one mount target for a One Zone file system. You must create that mount target in the same Availability Zone in which the file system is located. Use the `AvailabilityZoneName` and `AvailabiltyZoneId` properties in the DescribeFileSystems response object to get this information. Use the `subnetId` associated with the file system's Availability Zone when creating the mount target.
     *
     * For more information, see [Amazon EFS: How it Works](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
     *
     * To create a mount target for a file system, the file system's lifecycle state must be `available`. For more information, see DescribeFileSystems.
     *
     * In the request, provide the following:
     * + The file system ID for which you are creating the mount target.
     * + A subnet ID, which determines the following:
     *    + The VPC in which Amazon EFS creates the mount target
     *    + The Availability Zone in which Amazon EFS creates the mount target
     *    + The IP address range from which Amazon EFS selects the IP address of the mount target (if you don't specify an IP address in the request)
     *
     * After creating the mount target, Amazon EFS returns a response that includes, a `MountTargetId` and an `IpAddress`. You use this IP address when mounting the file system in an EC2 instance. You can also use the mount target's DNS name when mounting the file system. The EC2 instance on which you mount the file system by using the mount target can resolve the mount target's DNS name to its IP address. For more information, see [How it Works: Implementation Overview](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation).
     *
     * Note that you can create mount targets for a file system in only one VPC, and there can be only one mount target per Availability Zone. That is, if the file system already has one or more mount targets created for it, the subnet specified in the request to add another mount target must meet the following requirements:
     * + Must belong to the same VPC as the subnets of the existing mount targets
     * + Must not be in the same Availability Zone as any of the subnets of the existing mount targets
     *
     * If the request satisfies the requirements, Amazon EFS does the following:
     * + Creates a new mount target in the specified subnet.
     * + Also creates a new network interface in the subnet as follows:
     *    + If the request provides an `IpAddress`, Amazon EFS assigns that IP address to the network interface. Otherwise, Amazon EFS assigns a free address in the subnet (in the same way that the Amazon EC2 `CreateNetworkInterface` call does when a request does not specify a primary private IP address).
     *    + If the request provides `SecurityGroups`, this network interface is associated with those security groups. Otherwise, it belongs to the default security group for the subnet's VPC.
     *    + Assigns the description `Mount target <i>fsmt-id</i> for file system <i>fs-id</i> ` where ` <i>fsmt-id</i> ` is the mount target ID, and ` <i>fs-id</i> ` is the `FileSystemId`.
     *    + Sets the `requesterManaged` property of the network interface to `true`, and the `requesterId` value to `EFS`.
     * Each Amazon EFS mount target has one corresponding requester-managed EC2 network interface. After the network interface is created, Amazon EFS sets the `NetworkInterfaceId` field in the mount target's description to the network interface ID, and the `IpAddress` field to its address. If network interface creation fails, the entire `CreateMountTarget` operation fails.
     *
     * The `CreateMountTarget` call returns only after creating the network interface, but while the mount target state is still `creating`, you can check the mount target creation status by calling the DescribeMountTargets operation, which among other things returns the mount target state.
     *
     * We recommend that you create a mount target in each of the Availability Zones. There are cost considerations for using a file system in an Availability Zone through a mount target created in another Availability Zone. For more information, see [Amazon EFS pricing](http://aws.amazon.com/efs/pricing/). In addition, by always using a mount target local to the instance's Availability Zone, you eliminate a partial failure scenario. If the Availability Zone in which your mount target is created goes down, then you can't access your file system through that mount target.
     *
     * This operation requires permissions for the following action on the file system:
     * + `elasticfilesystem:CreateMountTarget`
     *
     * This operation also requires permissions for the following Amazon EC2 actions:
     * + `ec2:DescribeSubnets`
     * + `ec2:DescribeNetworkInterfaces`
     * + `ec2:CreateNetworkInterface`
     *
     * @sample aws.sdk.kotlin.services.efs.samples.CreateMountTarget.sample
     */
    public suspend fun createMountTarget(input: CreateMountTargetRequest): CreateMountTargetResponse

    /**
     * Creates a replication conﬁguration to either a new or existing EFS file system. For more information, see [Amazon EFS replication](https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html) in the *Amazon EFS User Guide*. The replication configuration specifies the following:
     * + **Source file system** – The EFS file system that you want to replicate.
     * + **Destination file system** – The destination file system to which the source file system is replicated. There can only be one destination file system in a replication configuration. A file system can be part of only one replication configuration. The destination parameters for the replication configuration depend on whether you are replicating to a new file system or to an existing file system, and if you are replicating across Amazon Web Services accounts. See DestinationToCreate for more information.
     *
     * This operation requires permissions for the `elasticfilesystem:CreateReplicationConfiguration` action. Additionally, other permissions are required depending on how you are replicating file systems. For more information, see [Required permissions for replication](https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html#efs-replication-permissions) in the *Amazon EFS User Guide*.
     */
    public suspend fun createReplicationConfiguration(input: CreateReplicationConfigurationRequest): CreateReplicationConfigurationResponse

    /**
     * DEPRECATED - `CreateTags` is deprecated and not maintained. To create tags for EFS resources, use the API action.
     *
     * Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If a tag key specified in the request already exists on the file system, this operation overwrites its value with the value provided in the request. If you add the `Name` tag to your file system, Amazon EFS returns it in the response to the DescribeFileSystems operation.
     *
     * This operation requires permission for the `elasticfilesystem:CreateTags` action.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.CreateTags.sample
     */
    @Deprecated("Use TagResource.")
    public suspend fun createTags(input: CreateTagsRequest): CreateTagsResponse

    /**
     * Deletes the specified access point. After deletion is complete, new clients can no longer connect to the access points. Clients connected to the access point at the time of deletion will continue to function until they terminate their connection.
     *
     * This operation requires permissions for the `elasticfilesystem:DeleteAccessPoint` action.
     */
    public suspend fun deleteAccessPoint(input: DeleteAccessPointRequest): DeleteAccessPointResponse

    /**
     * Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists and you can't access any contents of the deleted file system.
     *
     * You need to manually delete mount targets attached to a file system before you can delete an EFS file system. This step is performed for you when you use the Amazon Web Services console to delete a file system.
     *
     * You cannot delete a file system that is part of an EFS replication configuration. You need to delete the replication configuration first.
     *
     *  You can't delete a file system that is in use. That is, if the file system has any mount targets, you must first delete them. For more information, see DescribeMountTargets and DeleteMountTarget.
     *
     * The `DeleteFileSystem` call returns while the file system state is still `deleting`. You can check the file system deletion status by calling the DescribeFileSystems operation, which returns a list of file systems in your account. If you pass file system ID or creation token for the deleted file system, the DescribeFileSystems returns a `404 FileSystemNotFound` error.
     *
     * This operation requires permissions for the `elasticfilesystem:DeleteFileSystem` action.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.DeleteFileSystem.sample
     */
    public suspend fun deleteFileSystem(input: DeleteFileSystemRequest): DeleteFileSystemResponse

    /**
     * Deletes the `FileSystemPolicy` for the specified file system. The default `FileSystemPolicy` goes into effect once the existing policy is deleted. For more information about the default file system policy, see [Using Resource-based Policies with EFS](https://docs.aws.amazon.com/efs/latest/ug/res-based-policies-efs.html).
     *
     * This operation requires permissions for the `elasticfilesystem:DeleteFileSystemPolicy` action.
     */
    public suspend fun deleteFileSystemPolicy(input: DeleteFileSystemPolicyRequest): DeleteFileSystemPolicyResponse

    /**
     * Deletes the specified mount target.
     *
     * This operation forcibly breaks any mounts of the file system by using the mount target that is being deleted, which might disrupt instances or applications using those mounts. To avoid applications getting cut off abruptly, you might consider unmounting any mounts of the mount target, if feasible. The operation also deletes the associated network interface. Uncommitted writes might be lost, but breaking a mount target using this operation does not corrupt the file system itself. The file system you created remains. You can mount an EC2 instance in your VPC by using another mount target.
     *
     * This operation requires permissions for the following action on the file system:
     * + `elasticfilesystem:DeleteMountTarget`
     *
     * The `DeleteMountTarget` call returns while the mount target state is still `deleting`. You can check the mount target deletion by calling the DescribeMountTargets operation, which returns a list of mount target descriptions for the given file system.
     *
     * The operation also requires permissions for the following Amazon EC2 action on the mount target's network interface:
     * + `ec2:DeleteNetworkInterface`
     *
     * @sample aws.sdk.kotlin.services.efs.samples.DeleteMountTarget.sample
     */
    public suspend fun deleteMountTarget(input: DeleteMountTargetRequest): DeleteMountTargetResponse

    /**
     * Deletes a replication configuration. Deleting a replication configuration ends the replication process. After a replication configuration is deleted, the destination file system becomes `Writeable` and its replication overwrite protection is re-enabled. For more information, see [Delete a replication configuration](https://docs.aws.amazon.com/efs/latest/ug/delete-replications.html).
     *
     * This operation requires permissions for the `elasticfilesystem:DeleteReplicationConfiguration` action.
     */
    public suspend fun deleteReplicationConfiguration(input: DeleteReplicationConfigurationRequest): DeleteReplicationConfigurationResponse

    /**
     * DEPRECATED - `DeleteTags` is deprecated and not maintained. To remove tags from EFS resources, use the API action.
     *
     * Deletes the specified tags from a file system. If the `DeleteTags` request includes a tag key that doesn't exist, Amazon EFS ignores it and doesn't cause an error. For more information about tags and related restrictions, see [Tag restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management User Guide*.
     *
     * This operation requires permissions for the `elasticfilesystem:DeleteTags` action.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.DeleteTags.sample
     */
    @Deprecated("Use UntagResource.")
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Returns the description of a specific Amazon EFS access point if the `AccessPointId` is provided. If you provide an EFS `FileSystemId`, it returns descriptions of all access points for that file system. You can provide either an `AccessPointId` or a `FileSystemId` in the request, but not both.
     *
     * This operation requires permissions for the `elasticfilesystem:DescribeAccessPoints` action.
     */
    public suspend fun describeAccessPoints(input: DescribeAccessPointsRequest = DescribeAccessPointsRequest { }): DescribeAccessPointsResponse

    /**
     * Returns the account preferences settings for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.
     */
    public suspend fun describeAccountPreferences(input: DescribeAccountPreferencesRequest = DescribeAccountPreferencesRequest { }): DescribeAccountPreferencesResponse

    /**
     * Returns the backup policy for the specified EFS file system.
     */
    public suspend fun describeBackupPolicy(input: DescribeBackupPolicyRequest): DescribeBackupPolicyResponse

    /**
     * Returns the `FileSystemPolicy` for the specified EFS file system.
     *
     * This operation requires permissions for the `elasticfilesystem:DescribeFileSystemPolicy` action.
     */
    public suspend fun describeFileSystemPolicy(input: DescribeFileSystemPolicyRequest): DescribeFileSystemPolicyResponse

    /**
     * Returns the description of a specific Amazon EFS file system if either the file system `CreationToken` or the `FileSystemId` is provided. Otherwise, it returns descriptions of all file systems owned by the caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
     *
     * When retrieving all file system descriptions, you can optionally specify the `MaxItems` parameter to limit the number of descriptions in a response. This number is automatically set to 100. If more file system descriptions remain, Amazon EFS returns a `NextMarker`, an opaque token, in the response. In this case, you should send a subsequent request with the `Marker` request parameter set to the value of `NextMarker`.
     *
     * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where `DescribeFileSystems` is called first without the `Marker` and then the operation continues to call it with the `Marker` parameter set to the value of the `NextMarker` from the previous response until the response has no `NextMarker`.
     *
     *  The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multi-call iteration is unspecified.
     *
     *  This operation requires permissions for the `elasticfilesystem:DescribeFileSystems` action.
     */
    public suspend fun describeFileSystems(input: DescribeFileSystemsRequest = DescribeFileSystemsRequest { }): DescribeFileSystemsResponse

    /**
     * Returns the current `LifecycleConfiguration` object for the specified EFS file system. Lifecycle management uses the `LifecycleConfiguration` object to identify when to move files between storage classes. For a file system without a `LifecycleConfiguration` object, the call returns an empty array in the response.
     *
     * This operation requires permissions for the `elasticfilesystem:DescribeLifecycleConfiguration` operation.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.DescribeLifecycleConfiguration.sample
     */
    public suspend fun describeLifecycleConfiguration(input: DescribeLifecycleConfigurationRequest): DescribeLifecycleConfigurationResponse

    /**
     * Returns the security groups currently in effect for a mount target. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not `deleted`.
     *
     * This operation requires permissions for the following actions:
     * + `elasticfilesystem:DescribeMountTargetSecurityGroups` action on the mount target's file system.
     * + `ec2:DescribeNetworkInterfaceAttribute` action on the mount target's network interface.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.DescribeMountTargetSecurityGroups.sample
     */
    public suspend fun describeMountTargetSecurityGroups(input: DescribeMountTargetSecurityGroupsRequest): DescribeMountTargetSecurityGroupsResponse

    /**
     * Returns the descriptions of all the current mount targets, or a specific mount target, for a file system. When requesting all of the current mount targets, the order of mount targets returned in the response is unspecified.
     *
     * This operation requires permissions for the `elasticfilesystem:DescribeMountTargets` action, on either the file system ID that you specify in `FileSystemId`, or on the file system of the mount target that you specify in `MountTargetId`.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.DescribeMountTargets.sample
     */
    public suspend fun describeMountTargets(input: DescribeMountTargetsRequest = DescribeMountTargetsRequest { }): DescribeMountTargetsResponse

    /**
     * Retrieves the replication configuration for a specific file system. If a file system is not specified, all of the replication configurations for the Amazon Web Services account in an Amazon Web Services Region are retrieved.
     */
    public suspend fun describeReplicationConfigurations(input: DescribeReplicationConfigurationsRequest = DescribeReplicationConfigurationsRequest { }): DescribeReplicationConfigurationsResponse

    /**
     * DEPRECATED - The `DescribeTags` action is deprecated and not maintained. To view tags associated with EFS resources, use the `ListTagsForResource` API action.
     *
     * Returns the tags associated with a file system. The order of tags returned in the response of one `DescribeTags` call and the order of tags returned across the responses of a multiple-call iteration (when using pagination) is unspecified.
     *
     *  This operation requires permissions for the `elasticfilesystem:DescribeTags` action.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.DescribeTags.sample
     */
    @Deprecated("Use ListTagsForResource.")
    public suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve the tags for.
     *
     * This operation requires permissions for the `elasticfilesystem:DescribeAccessPoints` action.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Modifies the set of security groups in effect for a mount target.
     *
     * When you create a mount target, Amazon EFS also creates a new network interface. For more information, see CreateMountTarget. This operation replaces the security groups in effect for the network interface associated with a mount target, with the `SecurityGroups` provided in the request. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not `deleted`.
     *
     * The operation requires permissions for the following actions:
     * + `elasticfilesystem:ModifyMountTargetSecurityGroups` action on the mount target's file system.
     * + `ec2:ModifyNetworkInterfaceAttribute` action on the mount target's network interface.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.ModifyMountTargetSecurityGroups.sample
     */
    public suspend fun modifyMountTargetSecurityGroups(input: ModifyMountTargetSecurityGroupsRequest): ModifyMountTargetSecurityGroupsResponse

    /**
     * Use this operation to set the account preference in the current Amazon Web Services Region to use long 17 character (63 bit) or short 8 character (32 bit) resource IDs for new EFS file system and mount target resources. All existing resource IDs are not affected by any changes you make. You can set the ID preference during the opt-in period as EFS transitions to long resource IDs. For more information, see [Managing Amazon EFS resource IDs](https://docs.aws.amazon.com/efs/latest/ug/manage-efs-resource-ids.html).
     *
     * Starting in October, 2021, you will receive an error if you try to set the account preference to use the short 8 character format resource ID. Contact Amazon Web Services support if you receive an error and must use short IDs for file system and mount target resources.
     */
    public suspend fun putAccountPreferences(input: PutAccountPreferencesRequest): PutAccountPreferencesResponse

    /**
     * Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system.
     */
    public suspend fun putBackupPolicy(input: PutBackupPolicyRequest): PutBackupPolicyResponse

    /**
     * Applies an Amazon EFS `FileSystemPolicy` to an Amazon EFS file system. A file system policy is an IAM resource-based policy and can contain multiple policy statements. A file system always has exactly one file system policy, which can be the default policy or an explicit policy set or updated using this API operation. EFS file system policies have a 20,000 character limit. When an explicit policy is set, it overrides the default policy. For more information about the default file system policy, see [ Default EFS file system policy](https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy).
     *
     * EFS file system policies have a 20,000 character limit.
     *
     * This operation requires permissions for the `elasticfilesystem:PutFileSystemPolicy` action.
     */
    public suspend fun putFileSystemPolicy(input: PutFileSystemPolicyRequest): PutFileSystemPolicyResponse

    /**
     * Use this action to manage storage for your file system. A `LifecycleConfiguration` consists of one or more `LifecyclePolicy` objects that define the following:
     * + **`TransitionToIA`** – When to move files in the file system from primary storage (Standard storage class) into the Infrequent Access (IA) storage.
     * + **`TransitionToArchive`** – When to move files in the file system from their current storage class (either IA or Standard storage) into the Archive storage.File systems cannot transition into Archive storage before transitioning into IA storage. Therefore, TransitionToArchive must either not be set or must be later than TransitionToIA. The Archive storage class is available only for file systems that use the Elastic throughput mode and the General Purpose performance mode.
     *
     * + **`TransitionToPrimaryStorageClass`** – Whether to move files in the file system back to primary storage (Standard storage class) after they are accessed in IA or Archive storage.
     *
     * For more information, see [ Managing file system storage](https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html).
     *
     * Each Amazon EFS file system supports one lifecycle configuration, which applies to all files in the file system. If a `LifecycleConfiguration` object already exists for the specified file system, a `PutLifecycleConfiguration` call modifies the existing configuration. A `PutLifecycleConfiguration` call with an empty `LifecyclePolicies` array in the request body deletes any existing `LifecycleConfiguration`. In the request, specify the following:
     * + The ID for the file system for which you are enabling, disabling, or modifying lifecycle management.
     * + A `LifecyclePolicies` array of `LifecyclePolicy` objects that define when to move files to IA storage, to Archive storage, and back to primary storage.Amazon EFS requires that each `LifecyclePolicy` object have only have a single transition, so the `LifecyclePolicies` array needs to be structured with separate `LifecyclePolicy` objects. See the example requests in the following section for more information.
     *
     * This operation requires permissions for the `elasticfilesystem:PutLifecycleConfiguration` operation.
     *
     * To apply a `LifecycleConfiguration` object to an encrypted file system, you need the same Key Management Service permissions as when you created the encrypted file system.
     *
     * @sample aws.sdk.kotlin.services.efs.samples.PutLifecycleConfiguration.sample
     */
    public suspend fun putLifecycleConfiguration(input: PutLifecycleConfigurationRequest): PutLifecycleConfigurationResponse

    /**
     * Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API operation.
     *
     * This operation requires permissions for the `elasticfilesystem:TagResource` action.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API operation.
     *
     * This operation requires permissions for the `elasticfilesystem:UntagResource` action.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the throughput mode or the amount of provisioned throughput of an existing file system.
     */
    public suspend fun updateFileSystem(input: UpdateFileSystemRequest): UpdateFileSystemResponse

    /**
     * Updates protection on the file system.
     *
     * This operation requires permissions for the `elasticfilesystem:UpdateFileSystemProtection` action.
     */
    public suspend fun updateFileSystemProtection(input: UpdateFileSystemProtectionRequest): UpdateFileSystemProtectionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun EfsClient.withConfig(block: EfsClient.Config.Builder.() -> Unit): EfsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultEfsClient(newConfig)
}

/**
 * Creates an EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point. The operating system user and group override any identity information provided by the NFS client. The file system path is exposed as the access point's root directory. Applications using the access point can only access data in the application's own directory and any subdirectories. A file system can have a maximum of 10,000 access points unless you request an increase. To learn more, see [Mounting a file system using EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html).
 *
 * If multiple requests to create access points on the same file system are sent in quick succession, and the file system is near the limit of access points, you may experience a throttling response for these requests. This is to ensure that the file system does not exceed the stated access point limit.
 *
 * This operation requires permissions for the `elasticfilesystem:CreateAccessPoint` action.
 *
 * Access points can be tagged on creation. If tags are specified in the creation action, IAM performs additional authorization on the `elasticfilesystem:TagResource` action to verify if users have permissions to create tags. Therefore, you must grant explicit permissions to use the `elasticfilesystem:TagResource` action. For more information, see [Granting permissions to tag resources during creation](https://docs.aws.amazon.com/efs/latest/ug/using-tags-efs.html#supported-iam-actions-tagging.html).
 */
public suspend inline fun EfsClient.createAccessPoint(crossinline block: CreateAccessPointRequest.Builder.() -> Unit): CreateAccessPointResponse = createAccessPoint(CreateAccessPointRequest.Builder().apply(block).build())

/**
 * Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does not currently exist that is owned by the caller's Amazon Web Services account with the specified creation token, this operation does the following:
 * + Creates a new, empty file system. The file system will have an Amazon EFS assigned ID, and an initial lifecycle state `creating`.
 * + Returns with the description of the created file system.
 *
 * Otherwise, this operation returns a `FileSystemAlreadyExists` error with the ID of the existing file system.
 *
 * For basic use cases, you can use a randomly generated UUID for the creation token.
 *
 * The idempotent operation allows you to retry a `CreateFileSystem` call without risk of creating an extra file system. This can happen when an initial call fails in a way that leaves it uncertain whether or not a file system was actually created. An example might be that a transport level timeout occurred or your connection was reset. As long as you use the same creation token, if the initial call had succeeded in creating a file system, the client can learn of its existence from the `FileSystemAlreadyExists` error.
 *
 * For more information, see [Creating a file system](https://docs.aws.amazon.com/efs/latest/ug/creating-using-create-fs.html#creating-using-create-fs-part1) in the *Amazon EFS User Guide*.
 *
 * The `CreateFileSystem` call returns while the file system's lifecycle state is still `creating`. You can check the file system creation status by calling the DescribeFileSystems operation, which among other things returns the file system state.
 *
 * This operation accepts an optional `PerformanceMode` parameter that you choose for your file system. We recommend `generalPurpose``PerformanceMode` for all file systems. The `maxIO` mode is a previous generation performance type that is designed for highly parallelized workloads that can tolerate higher latencies than the `generalPurpose` mode. `MaxIO` mode is not supported for One Zone file systems or file systems that use Elastic throughput.
 *
 * The `PerformanceMode` can't be changed after the file system has been created. For more information, see [Amazon EFS performance modes](https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html).
 *
 * You can set the throughput mode for the file system using the `ThroughputMode` parameter.
 *
 * After the file system is fully created, Amazon EFS sets its lifecycle state to `available`, at which point you can create one or more mount targets for the file system in your VPC. For more information, see CreateMountTarget. You mount your Amazon EFS file system on an EC2 instances in your VPC by using the mount target. For more information, see [Amazon EFS: How it Works](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
 *
 * This operation requires permissions for the `elasticfilesystem:CreateFileSystem` action.
 *
 * File systems can be tagged on creation. If tags are specified in the creation action, IAM performs additional authorization on the `elasticfilesystem:TagResource` action to verify if users have permissions to create tags. Therefore, you must grant explicit permissions to use the `elasticfilesystem:TagResource` action. For more information, see [Granting permissions to tag resources during creation](https://docs.aws.amazon.com/efs/latest/ug/using-tags-efs.html#supported-iam-actions-tagging.html).
 */
public suspend inline fun EfsClient.createFileSystem(crossinline block: CreateFileSystemRequest.Builder.() -> Unit): CreateFileSystemResponse = createFileSystem(CreateFileSystemRequest.Builder().apply(block).build())

/**
 * Creates a mount target for a file system. You can then mount the file system on EC2 instances by using the mount target.
 *
 * You can create one mount target in each Availability Zone in your VPC. All EC2 instances in a VPC within a given Availability Zone share a single mount target for a given file system. If you have multiple subnets in an Availability Zone, you create a mount target in one of the subnets. EC2 instances do not need to be in the same subnet as the mount target in order to access their file system.
 *
 * You can create only one mount target for a One Zone file system. You must create that mount target in the same Availability Zone in which the file system is located. Use the `AvailabilityZoneName` and `AvailabiltyZoneId` properties in the DescribeFileSystems response object to get this information. Use the `subnetId` associated with the file system's Availability Zone when creating the mount target.
 *
 * For more information, see [Amazon EFS: How it Works](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
 *
 * To create a mount target for a file system, the file system's lifecycle state must be `available`. For more information, see DescribeFileSystems.
 *
 * In the request, provide the following:
 * + The file system ID for which you are creating the mount target.
 * + A subnet ID, which determines the following:
 *    + The VPC in which Amazon EFS creates the mount target
 *    + The Availability Zone in which Amazon EFS creates the mount target
 *    + The IP address range from which Amazon EFS selects the IP address of the mount target (if you don't specify an IP address in the request)
 *
 * After creating the mount target, Amazon EFS returns a response that includes, a `MountTargetId` and an `IpAddress`. You use this IP address when mounting the file system in an EC2 instance. You can also use the mount target's DNS name when mounting the file system. The EC2 instance on which you mount the file system by using the mount target can resolve the mount target's DNS name to its IP address. For more information, see [How it Works: Implementation Overview](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation).
 *
 * Note that you can create mount targets for a file system in only one VPC, and there can be only one mount target per Availability Zone. That is, if the file system already has one or more mount targets created for it, the subnet specified in the request to add another mount target must meet the following requirements:
 * + Must belong to the same VPC as the subnets of the existing mount targets
 * + Must not be in the same Availability Zone as any of the subnets of the existing mount targets
 *
 * If the request satisfies the requirements, Amazon EFS does the following:
 * + Creates a new mount target in the specified subnet.
 * + Also creates a new network interface in the subnet as follows:
 *    + If the request provides an `IpAddress`, Amazon EFS assigns that IP address to the network interface. Otherwise, Amazon EFS assigns a free address in the subnet (in the same way that the Amazon EC2 `CreateNetworkInterface` call does when a request does not specify a primary private IP address).
 *    + If the request provides `SecurityGroups`, this network interface is associated with those security groups. Otherwise, it belongs to the default security group for the subnet's VPC.
 *    + Assigns the description `Mount target <i>fsmt-id</i> for file system <i>fs-id</i> ` where ` <i>fsmt-id</i> ` is the mount target ID, and ` <i>fs-id</i> ` is the `FileSystemId`.
 *    + Sets the `requesterManaged` property of the network interface to `true`, and the `requesterId` value to `EFS`.
 * Each Amazon EFS mount target has one corresponding requester-managed EC2 network interface. After the network interface is created, Amazon EFS sets the `NetworkInterfaceId` field in the mount target's description to the network interface ID, and the `IpAddress` field to its address. If network interface creation fails, the entire `CreateMountTarget` operation fails.
 *
 * The `CreateMountTarget` call returns only after creating the network interface, but while the mount target state is still `creating`, you can check the mount target creation status by calling the DescribeMountTargets operation, which among other things returns the mount target state.
 *
 * We recommend that you create a mount target in each of the Availability Zones. There are cost considerations for using a file system in an Availability Zone through a mount target created in another Availability Zone. For more information, see [Amazon EFS pricing](http://aws.amazon.com/efs/pricing/). In addition, by always using a mount target local to the instance's Availability Zone, you eliminate a partial failure scenario. If the Availability Zone in which your mount target is created goes down, then you can't access your file system through that mount target.
 *
 * This operation requires permissions for the following action on the file system:
 * + `elasticfilesystem:CreateMountTarget`
 *
 * This operation also requires permissions for the following Amazon EC2 actions:
 * + `ec2:DescribeSubnets`
 * + `ec2:DescribeNetworkInterfaces`
 * + `ec2:CreateNetworkInterface`
 *
 * @sample aws.sdk.kotlin.services.efs.samples.CreateMountTarget.sample
 */
public suspend inline fun EfsClient.createMountTarget(crossinline block: CreateMountTargetRequest.Builder.() -> Unit): CreateMountTargetResponse = createMountTarget(CreateMountTargetRequest.Builder().apply(block).build())

/**
 * Creates a replication conﬁguration to either a new or existing EFS file system. For more information, see [Amazon EFS replication](https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html) in the *Amazon EFS User Guide*. The replication configuration specifies the following:
 * + **Source file system** – The EFS file system that you want to replicate.
 * + **Destination file system** – The destination file system to which the source file system is replicated. There can only be one destination file system in a replication configuration. A file system can be part of only one replication configuration. The destination parameters for the replication configuration depend on whether you are replicating to a new file system or to an existing file system, and if you are replicating across Amazon Web Services accounts. See DestinationToCreate for more information.
 *
 * This operation requires permissions for the `elasticfilesystem:CreateReplicationConfiguration` action. Additionally, other permissions are required depending on how you are replicating file systems. For more information, see [Required permissions for replication](https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html#efs-replication-permissions) in the *Amazon EFS User Guide*.
 */
public suspend inline fun EfsClient.createReplicationConfiguration(crossinline block: CreateReplicationConfigurationRequest.Builder.() -> Unit): CreateReplicationConfigurationResponse = createReplicationConfiguration(CreateReplicationConfigurationRequest.Builder().apply(block).build())

/**
 * DEPRECATED - `CreateTags` is deprecated and not maintained. To create tags for EFS resources, use the API action.
 *
 * Creates or overwrites tags associated with a file system. Each tag is a key-value pair. If a tag key specified in the request already exists on the file system, this operation overwrites its value with the value provided in the request. If you add the `Name` tag to your file system, Amazon EFS returns it in the response to the DescribeFileSystems operation.
 *
 * This operation requires permission for the `elasticfilesystem:CreateTags` action.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.CreateTags.sample
 */
@Deprecated("Use TagResource.")
public suspend inline fun EfsClient.createTags(crossinline block: CreateTagsRequest.Builder.() -> Unit): CreateTagsResponse = createTags(CreateTagsRequest.Builder().apply(block).build())

/**
 * Deletes the specified access point. After deletion is complete, new clients can no longer connect to the access points. Clients connected to the access point at the time of deletion will continue to function until they terminate their connection.
 *
 * This operation requires permissions for the `elasticfilesystem:DeleteAccessPoint` action.
 */
public suspend inline fun EfsClient.deleteAccessPoint(crossinline block: DeleteAccessPointRequest.Builder.() -> Unit): DeleteAccessPointResponse = deleteAccessPoint(DeleteAccessPointRequest.Builder().apply(block).build())

/**
 * Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists and you can't access any contents of the deleted file system.
 *
 * You need to manually delete mount targets attached to a file system before you can delete an EFS file system. This step is performed for you when you use the Amazon Web Services console to delete a file system.
 *
 * You cannot delete a file system that is part of an EFS replication configuration. You need to delete the replication configuration first.
 *
 *  You can't delete a file system that is in use. That is, if the file system has any mount targets, you must first delete them. For more information, see DescribeMountTargets and DeleteMountTarget.
 *
 * The `DeleteFileSystem` call returns while the file system state is still `deleting`. You can check the file system deletion status by calling the DescribeFileSystems operation, which returns a list of file systems in your account. If you pass file system ID or creation token for the deleted file system, the DescribeFileSystems returns a `404 FileSystemNotFound` error.
 *
 * This operation requires permissions for the `elasticfilesystem:DeleteFileSystem` action.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.DeleteFileSystem.sample
 */
public suspend inline fun EfsClient.deleteFileSystem(crossinline block: DeleteFileSystemRequest.Builder.() -> Unit): DeleteFileSystemResponse = deleteFileSystem(DeleteFileSystemRequest.Builder().apply(block).build())

/**
 * Deletes the `FileSystemPolicy` for the specified file system. The default `FileSystemPolicy` goes into effect once the existing policy is deleted. For more information about the default file system policy, see [Using Resource-based Policies with EFS](https://docs.aws.amazon.com/efs/latest/ug/res-based-policies-efs.html).
 *
 * This operation requires permissions for the `elasticfilesystem:DeleteFileSystemPolicy` action.
 */
public suspend inline fun EfsClient.deleteFileSystemPolicy(crossinline block: DeleteFileSystemPolicyRequest.Builder.() -> Unit): DeleteFileSystemPolicyResponse = deleteFileSystemPolicy(DeleteFileSystemPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified mount target.
 *
 * This operation forcibly breaks any mounts of the file system by using the mount target that is being deleted, which might disrupt instances or applications using those mounts. To avoid applications getting cut off abruptly, you might consider unmounting any mounts of the mount target, if feasible. The operation also deletes the associated network interface. Uncommitted writes might be lost, but breaking a mount target using this operation does not corrupt the file system itself. The file system you created remains. You can mount an EC2 instance in your VPC by using another mount target.
 *
 * This operation requires permissions for the following action on the file system:
 * + `elasticfilesystem:DeleteMountTarget`
 *
 * The `DeleteMountTarget` call returns while the mount target state is still `deleting`. You can check the mount target deletion by calling the DescribeMountTargets operation, which returns a list of mount target descriptions for the given file system.
 *
 * The operation also requires permissions for the following Amazon EC2 action on the mount target's network interface:
 * + `ec2:DeleteNetworkInterface`
 *
 * @sample aws.sdk.kotlin.services.efs.samples.DeleteMountTarget.sample
 */
public suspend inline fun EfsClient.deleteMountTarget(crossinline block: DeleteMountTargetRequest.Builder.() -> Unit): DeleteMountTargetResponse = deleteMountTarget(DeleteMountTargetRequest.Builder().apply(block).build())

/**
 * Deletes a replication configuration. Deleting a replication configuration ends the replication process. After a replication configuration is deleted, the destination file system becomes `Writeable` and its replication overwrite protection is re-enabled. For more information, see [Delete a replication configuration](https://docs.aws.amazon.com/efs/latest/ug/delete-replications.html).
 *
 * This operation requires permissions for the `elasticfilesystem:DeleteReplicationConfiguration` action.
 */
public suspend inline fun EfsClient.deleteReplicationConfiguration(crossinline block: DeleteReplicationConfigurationRequest.Builder.() -> Unit): DeleteReplicationConfigurationResponse = deleteReplicationConfiguration(DeleteReplicationConfigurationRequest.Builder().apply(block).build())

/**
 * DEPRECATED - `DeleteTags` is deprecated and not maintained. To remove tags from EFS resources, use the API action.
 *
 * Deletes the specified tags from a file system. If the `DeleteTags` request includes a tag key that doesn't exist, Amazon EFS ignores it and doesn't cause an error. For more information about tags and related restrictions, see [Tag restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html) in the *Billing and Cost Management User Guide*.
 *
 * This operation requires permissions for the `elasticfilesystem:DeleteTags` action.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.DeleteTags.sample
 */
@Deprecated("Use UntagResource.")
public suspend inline fun EfsClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Returns the description of a specific Amazon EFS access point if the `AccessPointId` is provided. If you provide an EFS `FileSystemId`, it returns descriptions of all access points for that file system. You can provide either an `AccessPointId` or a `FileSystemId` in the request, but not both.
 *
 * This operation requires permissions for the `elasticfilesystem:DescribeAccessPoints` action.
 */
public suspend inline fun EfsClient.describeAccessPoints(crossinline block: DescribeAccessPointsRequest.Builder.() -> Unit): DescribeAccessPointsResponse = describeAccessPoints(DescribeAccessPointsRequest.Builder().apply(block).build())

/**
 * Returns the account preferences settings for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region.
 */
public suspend inline fun EfsClient.describeAccountPreferences(crossinline block: DescribeAccountPreferencesRequest.Builder.() -> Unit): DescribeAccountPreferencesResponse = describeAccountPreferences(DescribeAccountPreferencesRequest.Builder().apply(block).build())

/**
 * Returns the backup policy for the specified EFS file system.
 */
public suspend inline fun EfsClient.describeBackupPolicy(crossinline block: DescribeBackupPolicyRequest.Builder.() -> Unit): DescribeBackupPolicyResponse = describeBackupPolicy(DescribeBackupPolicyRequest.Builder().apply(block).build())

/**
 * Returns the `FileSystemPolicy` for the specified EFS file system.
 *
 * This operation requires permissions for the `elasticfilesystem:DescribeFileSystemPolicy` action.
 */
public suspend inline fun EfsClient.describeFileSystemPolicy(crossinline block: DescribeFileSystemPolicyRequest.Builder.() -> Unit): DescribeFileSystemPolicyResponse = describeFileSystemPolicy(DescribeFileSystemPolicyRequest.Builder().apply(block).build())

/**
 * Returns the description of a specific Amazon EFS file system if either the file system `CreationToken` or the `FileSystemId` is provided. Otherwise, it returns descriptions of all file systems owned by the caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
 *
 * When retrieving all file system descriptions, you can optionally specify the `MaxItems` parameter to limit the number of descriptions in a response. This number is automatically set to 100. If more file system descriptions remain, Amazon EFS returns a `NextMarker`, an opaque token, in the response. In this case, you should send a subsequent request with the `Marker` request parameter set to the value of `NextMarker`.
 *
 * To retrieve a list of your file system descriptions, this operation is used in an iterative process, where `DescribeFileSystems` is called first without the `Marker` and then the operation continues to call it with the `Marker` parameter set to the value of the `NextMarker` from the previous response until the response has no `NextMarker`.
 *
 *  The order of file systems returned in the response of one `DescribeFileSystems` call and the order of file systems returned across the responses of a multi-call iteration is unspecified.
 *
 *  This operation requires permissions for the `elasticfilesystem:DescribeFileSystems` action.
 */
public suspend inline fun EfsClient.describeFileSystems(crossinline block: DescribeFileSystemsRequest.Builder.() -> Unit): DescribeFileSystemsResponse = describeFileSystems(DescribeFileSystemsRequest.Builder().apply(block).build())

/**
 * Returns the current `LifecycleConfiguration` object for the specified EFS file system. Lifecycle management uses the `LifecycleConfiguration` object to identify when to move files between storage classes. For a file system without a `LifecycleConfiguration` object, the call returns an empty array in the response.
 *
 * This operation requires permissions for the `elasticfilesystem:DescribeLifecycleConfiguration` operation.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.DescribeLifecycleConfiguration.sample
 */
public suspend inline fun EfsClient.describeLifecycleConfiguration(crossinline block: DescribeLifecycleConfigurationRequest.Builder.() -> Unit): DescribeLifecycleConfigurationResponse = describeLifecycleConfiguration(DescribeLifecycleConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the security groups currently in effect for a mount target. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not `deleted`.
 *
 * This operation requires permissions for the following actions:
 * + `elasticfilesystem:DescribeMountTargetSecurityGroups` action on the mount target's file system.
 * + `ec2:DescribeNetworkInterfaceAttribute` action on the mount target's network interface.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.DescribeMountTargetSecurityGroups.sample
 */
public suspend inline fun EfsClient.describeMountTargetSecurityGroups(crossinline block: DescribeMountTargetSecurityGroupsRequest.Builder.() -> Unit): DescribeMountTargetSecurityGroupsResponse = describeMountTargetSecurityGroups(DescribeMountTargetSecurityGroupsRequest.Builder().apply(block).build())

/**
 * Returns the descriptions of all the current mount targets, or a specific mount target, for a file system. When requesting all of the current mount targets, the order of mount targets returned in the response is unspecified.
 *
 * This operation requires permissions for the `elasticfilesystem:DescribeMountTargets` action, on either the file system ID that you specify in `FileSystemId`, or on the file system of the mount target that you specify in `MountTargetId`.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.DescribeMountTargets.sample
 */
public suspend inline fun EfsClient.describeMountTargets(crossinline block: DescribeMountTargetsRequest.Builder.() -> Unit): DescribeMountTargetsResponse = describeMountTargets(DescribeMountTargetsRequest.Builder().apply(block).build())

/**
 * Retrieves the replication configuration for a specific file system. If a file system is not specified, all of the replication configurations for the Amazon Web Services account in an Amazon Web Services Region are retrieved.
 */
public suspend inline fun EfsClient.describeReplicationConfigurations(crossinline block: DescribeReplicationConfigurationsRequest.Builder.() -> Unit): DescribeReplicationConfigurationsResponse = describeReplicationConfigurations(DescribeReplicationConfigurationsRequest.Builder().apply(block).build())

/**
 * DEPRECATED - The `DescribeTags` action is deprecated and not maintained. To view tags associated with EFS resources, use the `ListTagsForResource` API action.
 *
 * Returns the tags associated with a file system. The order of tags returned in the response of one `DescribeTags` call and the order of tags returned across the responses of a multiple-call iteration (when using pagination) is unspecified.
 *
 *  This operation requires permissions for the `elasticfilesystem:DescribeTags` action.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.DescribeTags.sample
 */
@Deprecated("Use ListTagsForResource.")
public suspend inline fun EfsClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve the tags for.
 *
 * This operation requires permissions for the `elasticfilesystem:DescribeAccessPoints` action.
 */
public suspend inline fun EfsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Modifies the set of security groups in effect for a mount target.
 *
 * When you create a mount target, Amazon EFS also creates a new network interface. For more information, see CreateMountTarget. This operation replaces the security groups in effect for the network interface associated with a mount target, with the `SecurityGroups` provided in the request. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not `deleted`.
 *
 * The operation requires permissions for the following actions:
 * + `elasticfilesystem:ModifyMountTargetSecurityGroups` action on the mount target's file system.
 * + `ec2:ModifyNetworkInterfaceAttribute` action on the mount target's network interface.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.ModifyMountTargetSecurityGroups.sample
 */
public suspend inline fun EfsClient.modifyMountTargetSecurityGroups(crossinline block: ModifyMountTargetSecurityGroupsRequest.Builder.() -> Unit): ModifyMountTargetSecurityGroupsResponse = modifyMountTargetSecurityGroups(ModifyMountTargetSecurityGroupsRequest.Builder().apply(block).build())

/**
 * Use this operation to set the account preference in the current Amazon Web Services Region to use long 17 character (63 bit) or short 8 character (32 bit) resource IDs for new EFS file system and mount target resources. All existing resource IDs are not affected by any changes you make. You can set the ID preference during the opt-in period as EFS transitions to long resource IDs. For more information, see [Managing Amazon EFS resource IDs](https://docs.aws.amazon.com/efs/latest/ug/manage-efs-resource-ids.html).
 *
 * Starting in October, 2021, you will receive an error if you try to set the account preference to use the short 8 character format resource ID. Contact Amazon Web Services support if you receive an error and must use short IDs for file system and mount target resources.
 */
public suspend inline fun EfsClient.putAccountPreferences(crossinline block: PutAccountPreferencesRequest.Builder.() -> Unit): PutAccountPreferencesResponse = putAccountPreferences(PutAccountPreferencesRequest.Builder().apply(block).build())

/**
 * Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system.
 */
public suspend inline fun EfsClient.putBackupPolicy(crossinline block: PutBackupPolicyRequest.Builder.() -> Unit): PutBackupPolicyResponse = putBackupPolicy(PutBackupPolicyRequest.Builder().apply(block).build())

/**
 * Applies an Amazon EFS `FileSystemPolicy` to an Amazon EFS file system. A file system policy is an IAM resource-based policy and can contain multiple policy statements. A file system always has exactly one file system policy, which can be the default policy or an explicit policy set or updated using this API operation. EFS file system policies have a 20,000 character limit. When an explicit policy is set, it overrides the default policy. For more information about the default file system policy, see [ Default EFS file system policy](https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy).
 *
 * EFS file system policies have a 20,000 character limit.
 *
 * This operation requires permissions for the `elasticfilesystem:PutFileSystemPolicy` action.
 */
public suspend inline fun EfsClient.putFileSystemPolicy(crossinline block: PutFileSystemPolicyRequest.Builder.() -> Unit): PutFileSystemPolicyResponse = putFileSystemPolicy(PutFileSystemPolicyRequest.Builder().apply(block).build())

/**
 * Use this action to manage storage for your file system. A `LifecycleConfiguration` consists of one or more `LifecyclePolicy` objects that define the following:
 * + **`TransitionToIA`** – When to move files in the file system from primary storage (Standard storage class) into the Infrequent Access (IA) storage.
 * + **`TransitionToArchive`** – When to move files in the file system from their current storage class (either IA or Standard storage) into the Archive storage.File systems cannot transition into Archive storage before transitioning into IA storage. Therefore, TransitionToArchive must either not be set or must be later than TransitionToIA. The Archive storage class is available only for file systems that use the Elastic throughput mode and the General Purpose performance mode.
 *
 * + **`TransitionToPrimaryStorageClass`** – Whether to move files in the file system back to primary storage (Standard storage class) after they are accessed in IA or Archive storage.
 *
 * For more information, see [ Managing file system storage](https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html).
 *
 * Each Amazon EFS file system supports one lifecycle configuration, which applies to all files in the file system. If a `LifecycleConfiguration` object already exists for the specified file system, a `PutLifecycleConfiguration` call modifies the existing configuration. A `PutLifecycleConfiguration` call with an empty `LifecyclePolicies` array in the request body deletes any existing `LifecycleConfiguration`. In the request, specify the following:
 * + The ID for the file system for which you are enabling, disabling, or modifying lifecycle management.
 * + A `LifecyclePolicies` array of `LifecyclePolicy` objects that define when to move files to IA storage, to Archive storage, and back to primary storage.Amazon EFS requires that each `LifecyclePolicy` object have only have a single transition, so the `LifecyclePolicies` array needs to be structured with separate `LifecyclePolicy` objects. See the example requests in the following section for more information.
 *
 * This operation requires permissions for the `elasticfilesystem:PutLifecycleConfiguration` operation.
 *
 * To apply a `LifecycleConfiguration` object to an encrypted file system, you need the same Key Management Service permissions as when you created the encrypted file system.
 *
 * @sample aws.sdk.kotlin.services.efs.samples.PutLifecycleConfiguration.sample
 */
public suspend inline fun EfsClient.putLifecycleConfiguration(crossinline block: PutLifecycleConfigurationRequest.Builder.() -> Unit): PutLifecycleConfigurationResponse = putLifecycleConfiguration(PutLifecycleConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API operation.
 *
 * This operation requires permissions for the `elasticfilesystem:TagResource` action.
 */
public suspend inline fun EfsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API operation.
 *
 * This operation requires permissions for the `elasticfilesystem:UntagResource` action.
 */
public suspend inline fun EfsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the throughput mode or the amount of provisioned throughput of an existing file system.
 */
public suspend inline fun EfsClient.updateFileSystem(crossinline block: UpdateFileSystemRequest.Builder.() -> Unit): UpdateFileSystemResponse = updateFileSystem(UpdateFileSystemRequest.Builder().apply(block).build())

/**
 * Updates protection on the file system.
 *
 * This operation requires permissions for the `elasticfilesystem:UpdateFileSystemProtection` action.
 */
public suspend inline fun EfsClient.updateFileSystemProtection(crossinline block: UpdateFileSystemProtectionRequest.Builder.() -> Unit): UpdateFileSystemProtectionResponse = updateFileSystemProtection(UpdateFileSystemProtectionRequest.Builder().apply(block).build())
