// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutLifecycleConfigurationRequest private constructor(builder: Builder) {
    /**
     * The ID of the file system for which you are creating the `LifecycleConfiguration` object (String).
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object. A `LifecycleConfiguration` object informs lifecycle management of the following:
     * + **`TransitionToIA`** – When to move files in the file system from primary storage (Standard storage class) into the Infrequent Access (IA) storage.
     * + **`TransitionToArchive`** – When to move files in the file system from their current storage class (either IA or Standard storage) into the Archive storage.File systems cannot transition into Archive storage before transitioning into IA storage. Therefore, TransitionToArchive must either not be set or must be later than TransitionToIA.The Archive storage class is available only for file systems that use the Elastic throughput mode and the General Purpose performance mode.
     * + **`TransitionToPrimaryStorageClass`** – Whether to move files in the file system back to primary storage (Standard storage class) after they are accessed in IA or Archive storage.
     *
     * When using the `put-lifecycle-configuration` CLI command or the `PutLifecycleConfiguration` API action, Amazon EFS requires that each `LifecyclePolicy` object have only a single transition. This means that in a request body, `LifecyclePolicies` must be structured as an array of `LifecyclePolicy` objects, one object for each storage transition. See the example requests in the following section for more information.
     */
    public val lifecyclePolicies: List<LifecyclePolicy>? = builder.lifecyclePolicies

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutLifecycleConfigurationRequest(")
        append("fileSystemId=$fileSystemId,")
        append("lifecyclePolicies=$lifecyclePolicies")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (lifecyclePolicies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutLifecycleConfigurationRequest

        if (fileSystemId != other.fileSystemId) return false
        if (lifecyclePolicies != other.lifecyclePolicies) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the file system for which you are creating the `LifecycleConfiguration` object (String).
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object. A `LifecycleConfiguration` object informs lifecycle management of the following:
         * + **`TransitionToIA`** – When to move files in the file system from primary storage (Standard storage class) into the Infrequent Access (IA) storage.
         * + **`TransitionToArchive`** – When to move files in the file system from their current storage class (either IA or Standard storage) into the Archive storage.File systems cannot transition into Archive storage before transitioning into IA storage. Therefore, TransitionToArchive must either not be set or must be later than TransitionToIA.The Archive storage class is available only for file systems that use the Elastic throughput mode and the General Purpose performance mode.
         * + **`TransitionToPrimaryStorageClass`** – Whether to move files in the file system back to primary storage (Standard storage class) after they are accessed in IA or Archive storage.
         *
         * When using the `put-lifecycle-configuration` CLI command or the `PutLifecycleConfiguration` API action, Amazon EFS requires that each `LifecyclePolicy` object have only a single transition. This means that in a request body, `LifecyclePolicies` must be structured as an array of `LifecyclePolicy` objects, one object for each storage transition. See the example requests in the following section for more information.
         */
        public var lifecyclePolicies: List<LifecyclePolicy>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest) : this() {
            this.fileSystemId = x.fileSystemId
            this.lifecyclePolicies = x.lifecyclePolicies
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest = PutLifecycleConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
