// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateFileSystemRequest private constructor(builder: Builder) {
    /**
     * For One Zone file systems, specify the Amazon Web Services Availability Zone in which to create the file system. Use the format `us-east-1a` to specify the Availability Zone. For more information about One Zone file systems, see [EFS file system types](https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html#file-system-type) in the *Amazon EFS User Guide*.
     *
     * One Zone file systems are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS is available.
     */
    public val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to `true` to enable automatic backups. If you are creating a One Zone file system, automatic backups are enabled by default. For more information, see [Automatic backups](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups) in the *Amazon EFS User Guide*.
     *
     * Default is `false`. However, if you specify an `AvailabilityZoneName`, the default is `true`.
     *
     * Backup is not available in all Amazon Web Services Regions where Amazon EFS is available.
     */
    public val backup: kotlin.Boolean? = builder.backup
    /**
     * A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     */
    public val creationToken: kotlin.String? = builder.creationToken
    /**
     * A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying an existing Key Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key for Amazon EFS, `/aws/elasticfilesystem`, is used to protect the encrypted file system.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The ID of the KMS key that you want to use to protect the encrypted file system. This parameter is required only if you want to use a non-default KMS key. If this parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a KMS key ID using the following formats:
     * + Key ID - A unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + ARN - An Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
     * + Key alias ARN - An ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
     *
     * If you use `KmsKeyId`, you must set the CreateFileSystemRequest$Encrypted parameter to true.
     *
     * EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS file systems.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The performance mode of the file system. We recommend `generalPurpose` performance mode for all file systems. File systems using the `maxIO` performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created. The `maxIO` mode is not supported on One Zone file systems.
     *
     * Due to the higher per-operation latencies with Max I/O, we recommend using General Purpose performance mode for all file systems.
     *
     * Default is `generalPurpose`.
     */
    public val performanceMode: aws.sdk.kotlin.services.efs.model.PerformanceMode? = builder.performanceMode
    /**
     * The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating. Required if `ThroughputMode` is set to `provisioned`. Valid values are 1-3414 MiBps, with the upper limit depending on Region. To increase this limit, contact Amazon Web Services Support. For more information, see [Amazon EFS quotas that you can increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the *Amazon EFS User Guide*.
     */
    public val provisionedThroughputInMibPs: kotlin.Double? = builder.provisionedThroughputInMibPs
    /**
     * Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a `"Key":"Name","Value":"{value}"` key-value pair. Each key must be unique. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies the throughput mode for the file system. The mode can be `bursting`, `provisioned`, or `elastic`. If you set `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`. After you create the file system, you can decrease your file system's Provisioned throughput or change between the throughput modes, with certain time restrictions. For more information, see [Specifying throughput with provisioned mode](https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput) in the *Amazon EFS User Guide*.
     *
     * Default is `bursting`.
     */
    public val throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = builder.throughputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemRequest(")
        append("availabilityZoneName=$availabilityZoneName,")
        append("backup=$backup,")
        append("creationToken=$creationToken,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("performanceMode=$performanceMode,")
        append("provisionedThroughputInMibPs=$provisionedThroughputInMibPs,")
        append("tags=$tags,")
        append("throughputMode=$throughputMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneName?.hashCode() ?: 0
        result = 31 * result + (backup?.hashCode() ?: 0)
        result = 31 * result + (creationToken?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceMode?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughputInMibPs?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemRequest

        if (availabilityZoneName != other.availabilityZoneName) return false
        if (backup != other.backup) return false
        if (creationToken != other.creationToken) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (performanceMode != other.performanceMode) return false
        if (!(provisionedThroughputInMibPs?.equals(other.provisionedThroughputInMibPs) ?: (other.provisionedThroughputInMibPs == null))) return false
        if (tags != other.tags) return false
        if (throughputMode != other.throughputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For One Zone file systems, specify the Amazon Web Services Availability Zone in which to create the file system. Use the format `us-east-1a` to specify the Availability Zone. For more information about One Zone file systems, see [EFS file system types](https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html#file-system-type) in the *Amazon EFS User Guide*.
         *
         * One Zone file systems are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS is available.
         */
        public var availabilityZoneName: kotlin.String? = null
        /**
         * Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to `true` to enable automatic backups. If you are creating a One Zone file system, automatic backups are enabled by default. For more information, see [Automatic backups](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups) in the *Amazon EFS User Guide*.
         *
         * Default is `false`. However, if you specify an `AvailabilityZoneName`, the default is `true`.
         *
         * Backup is not available in all Amazon Web Services Regions where Amazon EFS is available.
         */
        public var backup: kotlin.Boolean? = null
        /**
         * A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         */
        public var creationToken: kotlin.String? = null
        /**
         * A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying an existing Key Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key for Amazon EFS, `/aws/elasticfilesystem`, is used to protect the encrypted file system.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The ID of the KMS key that you want to use to protect the encrypted file system. This parameter is required only if you want to use a non-default KMS key. If this parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a KMS key ID using the following formats:
         * + Key ID - A unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + ARN - An Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
         * + Key alias ARN - An ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
         *
         * If you use `KmsKeyId`, you must set the CreateFileSystemRequest$Encrypted parameter to true.
         *
         * EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS file systems.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The performance mode of the file system. We recommend `generalPurpose` performance mode for all file systems. File systems using the `maxIO` performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created. The `maxIO` mode is not supported on One Zone file systems.
         *
         * Due to the higher per-operation latencies with Max I/O, we recommend using General Purpose performance mode for all file systems.
         *
         * Default is `generalPurpose`.
         */
        public var performanceMode: aws.sdk.kotlin.services.efs.model.PerformanceMode? = null
        /**
         * The throughput, measured in mebibytes per second (MiBps), that you want to provision for a file system that you're creating. Required if `ThroughputMode` is set to `provisioned`. Valid values are 1-3414 MiBps, with the upper limit depending on Region. To increase this limit, contact Amazon Web Services Support. For more information, see [Amazon EFS quotas that you can increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the *Amazon EFS User Guide*.
         */
        public var provisionedThroughputInMibPs: kotlin.Double? = null
        /**
         * Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a `"Key":"Name","Value":"{value}"` key-value pair. Each key must be unique. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies the throughput mode for the file system. The mode can be `bursting`, `provisioned`, or `elastic`. If you set `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`. After you create the file system, you can decrease your file system's Provisioned throughput or change between the throughput modes, with certain time restrictions. For more information, see [Specifying throughput with provisioned mode](https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput) in the *Amazon EFS User Guide*.
         *
         * Default is `bursting`.
         */
        public var throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest) : this() {
            this.availabilityZoneName = x.availabilityZoneName
            this.backup = x.backup
            this.creationToken = x.creationToken
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.performanceMode = x.performanceMode
            this.provisionedThroughputInMibPs = x.provisionedThroughputInMibPs
            this.tags = x.tags
            this.throughputMode = x.throughputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest = CreateFileSystemRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
