// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * Returned if the access point that you are trying to create already exists, with the creation token you provided in the request.
 */
public class AccessPointAlreadyExists private constructor(builder: Builder) : EfsException(builder.message) {

    public val accessPointId: kotlin.String = requireNotNull(builder.accessPointId) { "A non-null value must be provided for accessPointId" }
    /**
     * The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type.
     */
    public val errorCode: kotlin.String = requireNotNull(builder.errorCode) { "A non-null value must be provided for errorCode" }

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.AccessPointAlreadyExists = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPointAlreadyExists(")
        append("accessPointId=$accessPointId,")
        append("errorCode=$errorCode,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointId.hashCode()
        result = 31 * result + (errorCode.hashCode())
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessPointAlreadyExists

        if (accessPointId != other.accessPointId) return false
        if (errorCode != other.errorCode) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.AccessPointAlreadyExists = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var accessPointId: kotlin.String? = null
        /**
         * The error code is a string that uniquely identifies an error condition. It is meant to be read and understood by programs that detect and handle errors by type.
         */
        public var errorCode: kotlin.String? = null
        /**
         * The error message contains a generic description of the error condition in English. It is intended for a human audience. Simple programs display the message directly to the end user if they encounter an error condition they don't know how or don't care to handle. Sophisticated programs with more exhaustive error handling and proper internationalization are more likely to ignore the error message.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.AccessPointAlreadyExists) : this() {
            this.accessPointId = x.accessPointId
            this.errorCode = x.errorCode
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.AccessPointAlreadyExists = AccessPointAlreadyExists(this)

        internal fun correctErrors(): Builder {
            if (accessPointId == null) accessPointId = ""
            if (errorCode == null) errorCode = ""
            return this
        }
    }
}
