// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest
import aws.sdk.kotlin.services.efs.model.PerformanceMode
import aws.sdk.kotlin.services.efs.model.Tag
import aws.sdk.kotlin.services.efs.model.ThroughputMode
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFileSystemOperationSerializer: HttpSerializer.NonStreaming<CreateFileSystemRequest> {
    override fun serialize(context: ExecutionContext, input: CreateFileSystemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/2015-02-01/file-systems"
        }

        val payload = serializeCreateFileSystemOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateFileSystemOperationBody(context: ExecutionContext, input: CreateFileSystemRequest): ByteArray {
    val serializer = JsonSerializer()
    val AVAILABILITYZONENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZoneName"))
    val BACKUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Backup"))
    val CREATIONTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreationToken"))
    val ENCRYPTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Encrypted"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KmsKeyId"))
    val PERFORMANCEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("PerformanceMode"))
    val PROVISIONEDTHROUGHPUTINMIBPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("ProvisionedThroughputInMibps"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val THROUGHPUTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ThroughputMode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONENAME_DESCRIPTOR)
        field(BACKUP_DESCRIPTOR)
        field(CREATIONTOKEN_DESCRIPTOR)
        field(ENCRYPTED_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(PERFORMANCEMODE_DESCRIPTOR)
        field(PROVISIONEDTHROUGHPUTINMIBPS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(THROUGHPUTMODE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.availabilityZoneName?.let { field(AVAILABILITYZONENAME_DESCRIPTOR, it) }
        input.backup?.let { field(BACKUP_DESCRIPTOR, it) }
        input.creationToken?.let { field(CREATIONTOKEN_DESCRIPTOR, it) } ?: field(CREATIONTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.encrypted?.let { field(ENCRYPTED_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.performanceMode?.let { field(PERFORMANCEMODE_DESCRIPTOR, it.value) }
        input.provisionedThroughputInMibPs?.let { field(PROVISIONEDTHROUGHPUTINMIBPS_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.throughputMode?.let { field(THROUGHPUTMODE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
