// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the new or existing destination file system for the replication configuration.
 */
public class DestinationToCreate private constructor(builder: Builder) {
    /**
     * To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to create the destination file system.
     */
    public val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * The ID of the file system to use for the destination. The file system's replication overwrite replication must be disabled. If you do not provide an ID, then EFS creates a new file system for the replication destination.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * Specify the Key Management Service (KMS) key that you want to use to encrypt the destination file system. If you do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS, `/aws/elasticfilesystem`. This ID can be in one of the following formats:
     * + Key ID - The unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + ARN - The Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
     * + Key alias ARN - The ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to create the destination file system.
     */
    public val region: kotlin.String? = builder.region

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.DestinationToCreate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationToCreate(")
        append("availabilityZoneName=$availabilityZoneName,")
        append("fileSystemId=$fileSystemId,")
        append("kmsKeyId=$kmsKeyId,")
        append("region=$region")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneName?.hashCode() ?: 0
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationToCreate

        if (availabilityZoneName != other.availabilityZoneName) return false
        if (fileSystemId != other.fileSystemId) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (region != other.region) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.DestinationToCreate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * To create a file system that uses One Zone storage, specify the name of the Availability Zone in which to create the destination file system.
         */
        public var availabilityZoneName: kotlin.String? = null
        /**
         * The ID of the file system to use for the destination. The file system's replication overwrite replication must be disabled. If you do not provide an ID, then EFS creates a new file system for the replication destination.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * Specify the Key Management Service (KMS) key that you want to use to encrypt the destination file system. If you do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS, `/aws/elasticfilesystem`. This ID can be in one of the following formats:
         * + Key ID - The unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + ARN - The Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
         * + Key alias ARN - The ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to create the destination file system.
         */
        public var region: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.DestinationToCreate) : this() {
            this.availabilityZoneName = x.availabilityZoneName
            this.fileSystemId = x.fileSystemId
            this.kmsKeyId = x.kmsKeyId
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.DestinationToCreate = DestinationToCreate(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
