// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A description of the file system.
 */
public class CreateFileSystemResponse private constructor(builder: Builder) {
    /**
     * The unique and consistent identifier of the Availability Zone in which the file system is located, and is valid only for One Zone file systems. For example, `use1-az1` is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for One Zone file systems. For more information, see [Using EFS storage classes](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) in the *Amazon EFS User Guide*.
     */
    public val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The opaque string specified in the request.
     */
    public val creationToken: kotlin.String = requireNotNull(builder.creationToken) { "A non-null value must be provided for creationToken" }
    /**
     * A Boolean value that, if true, indicates that the file system is encrypted.
     */
    public val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The Amazon Resource Name (ARN) for the EFS file system, in the format `arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> `. Example with sample data: `arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567`
     */
    public val fileSystemArn: kotlin.String? = builder.fileSystemArn
    /**
     * The ID of the file system, assigned by Amazon EFS.
     */
    public val fileSystemId: kotlin.String = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }
    /**
     * Describes the protection on the file system.
     */
    public val fileSystemProtection: aws.sdk.kotlin.services.efs.model.FileSystemProtectionDescription? = builder.fileSystemProtection
    /**
     * The ID of an KMS key used to protect the encrypted file system.
     */
    public val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The lifecycle phase of the file system.
     */
    public val lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState = requireNotNull(builder.lifeCycleState) { "A non-null value must be provided for lifeCycleState" }
    /**
     * You can add tags to a file system, including a `Name` tag. For more information, see CreateFileSystem. If the file system has a `Name` tag, Amazon EFS returns the value in this field.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The current number of mount targets that the file system has. For more information, see CreateMountTarget.
     */
    public val numberOfMountTargets: kotlin.Int = builder.numberOfMountTargets
    /**
     * The Amazon Web Services account that created the file system.
     */
    public val ownerId: kotlin.String = requireNotNull(builder.ownerId) { "A non-null value must be provided for ownerId" }
    /**
     * The Performance mode of the file system.
     */
    public val performanceMode: aws.sdk.kotlin.services.efs.model.PerformanceMode = requireNotNull(builder.performanceMode) { "A non-null value must be provided for performanceMode" }
    /**
     * The amount of provisioned throughput, measured in MiBps, for the file system. Valid for file systems using `ThroughputMode` set to `provisioned`.
     */
    public val provisionedThroughputInMibPs: kotlin.Double? = builder.provisionedThroughputInMibPs
    /**
     * The latest known metered size (in bytes) of data stored in the file system, in its `Value` field, and the time at which that size was determined in its `Timestamp` field. The `Timestamp` value is the integer number of seconds since 1970-01-01T00:00:00Z. The `SizeInBytes` value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, `SizeInBytes` represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time.
     */
    public val sizeInBytes: aws.sdk.kotlin.services.efs.model.FileSystemSize? = builder.sizeInBytes
    /**
     * The tags associated with the file system, presented as an array of `Tag` objects.
     */
    public val tags: List<Tag> = requireNotNull(builder.tags) { "A non-null value must be provided for tags" }
    /**
     * Displays the file system's throughput mode. For more information, see [Throughput modes](https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes) in the *Amazon EFS User Guide*.
     */
    public val throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = builder.throughputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateFileSystemResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemResponse(")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availabilityZoneName=$availabilityZoneName,")
        append("creationTime=$creationTime,")
        append("creationToken=$creationToken,")
        append("encrypted=$encrypted,")
        append("fileSystemArn=$fileSystemArn,")
        append("fileSystemId=$fileSystemId,")
        append("fileSystemProtection=$fileSystemProtection,")
        append("kmsKeyId=$kmsKeyId,")
        append("lifeCycleState=$lifeCycleState,")
        append("name=$name,")
        append("numberOfMountTargets=$numberOfMountTargets,")
        append("ownerId=$ownerId,")
        append("performanceMode=$performanceMode,")
        append("provisionedThroughputInMibPs=$provisionedThroughputInMibPs,")
        append("sizeInBytes=$sizeInBytes,")
        append("tags=$tags,")
        append("throughputMode=$throughputMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneId?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneName?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (creationToken.hashCode())
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (fileSystemArn?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId.hashCode())
        result = 31 * result + (fileSystemProtection?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (lifeCycleState.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberOfMountTargets)
        result = 31 * result + (ownerId.hashCode())
        result = 31 * result + (performanceMode.hashCode())
        result = 31 * result + (provisionedThroughputInMibPs?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (tags.hashCode())
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemResponse

        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availabilityZoneName != other.availabilityZoneName) return false
        if (creationTime != other.creationTime) return false
        if (creationToken != other.creationToken) return false
        if (encrypted != other.encrypted) return false
        if (fileSystemArn != other.fileSystemArn) return false
        if (fileSystemId != other.fileSystemId) return false
        if (fileSystemProtection != other.fileSystemProtection) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (lifeCycleState != other.lifeCycleState) return false
        if (name != other.name) return false
        if (numberOfMountTargets != other.numberOfMountTargets) return false
        if (ownerId != other.ownerId) return false
        if (performanceMode != other.performanceMode) return false
        if (!(provisionedThroughputInMibPs?.equals(other.provisionedThroughputInMibPs) ?: (other.provisionedThroughputInMibPs == null))) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (tags != other.tags) return false
        if (throughputMode != other.throughputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateFileSystemResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique and consistent identifier of the Availability Zone in which the file system is located, and is valid only for One Zone file systems. For example, `use1-az1` is an Availability Zone ID for the us-east-1 Amazon Web Services Region, and it has the same location in every Amazon Web Services account.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * Describes the Amazon Web Services Availability Zone in which the file system is located, and is valid only for One Zone file systems. For more information, see [Using EFS storage classes](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) in the *Amazon EFS User Guide*.
         */
        public var availabilityZoneName: kotlin.String? = null
        /**
         * The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The opaque string specified in the request.
         */
        public var creationToken: kotlin.String? = null
        /**
         * A Boolean value that, if true, indicates that the file system is encrypted.
         */
        public var encrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) for the EFS file system, in the format `arn:aws:elasticfilesystem:<i>region</i>:<i>account-id</i>:file-system/<i>file-system-id</i> `. Example with sample data: `arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567`
         */
        public var fileSystemArn: kotlin.String? = null
        /**
         * The ID of the file system, assigned by Amazon EFS.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * Describes the protection on the file system.
         */
        public var fileSystemProtection: aws.sdk.kotlin.services.efs.model.FileSystemProtectionDescription? = null
        /**
         * The ID of an KMS key used to protect the encrypted file system.
         */
        public var kmsKeyId: kotlin.String? = null
        /**
         * The lifecycle phase of the file system.
         */
        public var lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState? = null
        /**
         * You can add tags to a file system, including a `Name` tag. For more information, see CreateFileSystem. If the file system has a `Name` tag, Amazon EFS returns the value in this field.
         */
        public var name: kotlin.String? = null
        /**
         * The current number of mount targets that the file system has. For more information, see CreateMountTarget.
         */
        public var numberOfMountTargets: kotlin.Int = 0
        /**
         * The Amazon Web Services account that created the file system.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The Performance mode of the file system.
         */
        public var performanceMode: aws.sdk.kotlin.services.efs.model.PerformanceMode? = null
        /**
         * The amount of provisioned throughput, measured in MiBps, for the file system. Valid for file systems using `ThroughputMode` set to `provisioned`.
         */
        public var provisionedThroughputInMibPs: kotlin.Double? = null
        /**
         * The latest known metered size (in bytes) of data stored in the file system, in its `Value` field, and the time at which that size was determined in its `Timestamp` field. The `Timestamp` value is the integer number of seconds since 1970-01-01T00:00:00Z. The `SizeInBytes` value doesn't represent the size of a consistent snapshot of the file system, but it is eventually consistent when there are no writes to the file system. That is, `SizeInBytes` represents actual size only if the file system is not modified for a period longer than a couple of hours. Otherwise, the value is not the exact size that the file system was at any point in time.
         */
        public var sizeInBytes: aws.sdk.kotlin.services.efs.model.FileSystemSize? = null
        /**
         * The tags associated with the file system, presented as an array of `Tag` objects.
         */
        public var tags: List<Tag>? = null
        /**
         * Displays the file system's throughput mode. For more information, see [Throughput modes](https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes) in the *Amazon EFS User Guide*.
         */
        public var throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateFileSystemResponse) : this() {
            this.availabilityZoneId = x.availabilityZoneId
            this.availabilityZoneName = x.availabilityZoneName
            this.creationTime = x.creationTime
            this.creationToken = x.creationToken
            this.encrypted = x.encrypted
            this.fileSystemArn = x.fileSystemArn
            this.fileSystemId = x.fileSystemId
            this.fileSystemProtection = x.fileSystemProtection
            this.kmsKeyId = x.kmsKeyId
            this.lifeCycleState = x.lifeCycleState
            this.name = x.name
            this.numberOfMountTargets = x.numberOfMountTargets
            this.ownerId = x.ownerId
            this.performanceMode = x.performanceMode
            this.provisionedThroughputInMibPs = x.provisionedThroughputInMibPs
            this.sizeInBytes = x.sizeInBytes
            this.tags = x.tags
            this.throughputMode = x.throughputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateFileSystemResponse = CreateFileSystemResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.efs.model.FileSystemProtectionDescription] inside the given [block]
         */
        public fun fileSystemProtection(block: aws.sdk.kotlin.services.efs.model.FileSystemProtectionDescription.Builder.() -> kotlin.Unit) {
            this.fileSystemProtection = aws.sdk.kotlin.services.efs.model.FileSystemProtectionDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.efs.model.FileSystemSize] inside the given [block]
         */
        public fun sizeInBytes(block: aws.sdk.kotlin.services.efs.model.FileSystemSize.Builder.() -> kotlin.Unit) {
            this.sizeInBytes = aws.sdk.kotlin.services.efs.model.FileSystemSize.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (creationToken == null) creationToken = ""
            if (fileSystemId == null) fileSystemId = ""
            if (lifeCycleState == null) lifeCycleState = LifeCycleState.SdkUnknown("no value provided")
            if (ownerId == null) ownerId = ""
            if (performanceMode == null) performanceMode = PerformanceMode.SdkUnknown("no value provided")
            if (tags == null) tags = emptyList()
            return this
        }
    }
}
