// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.ThroughputMode
import aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateFileSystemOperationSerializer: HttpSerializer.NonStreaming<UpdateFileSystemRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateFileSystemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.fileSystemId) { "fileSystemId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("2015-02-01"))
                add(PercentEncoding.Path.encode("file-systems"))
                add(PercentEncoding.SmithyLabel.encode("${input.fileSystemId}"))
            }
        }

        val payload = serializeUpdateFileSystemOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFileSystemOperationBody(context: ExecutionContext, input: UpdateFileSystemRequest): ByteArray {
    val serializer = JsonSerializer()
    val PROVISIONEDTHROUGHPUTINMIBPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Double, JsonSerialName("ProvisionedThroughputInMibps"))
    val THROUGHPUTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ThroughputMode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROVISIONEDTHROUGHPUTINMIBPS_DESCRIPTOR)
        field(THROUGHPUTMODE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.provisionedThroughputInMibPs?.let { field(PROVISIONEDTHROUGHPUTINMIBPS_DESCRIPTOR, it) }
        input.throughputMode?.let { field(THROUGHPUTMODE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
