// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.EfsException
import aws.sdk.kotlin.services.efs.model.ModifyMountTargetSecurityGroupsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ModifyMountTargetSecurityGroupsOperationDeserializer: HttpDeserializer.NonStreaming<ModifyMountTargetSecurityGroupsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ModifyMountTargetSecurityGroupsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwModifyMountTargetSecurityGroupsError(context, call, payload)
        }
        val builder = ModifyMountTargetSecurityGroupsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwModifyMountTargetSecurityGroupsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "IncorrectMountTargetState" -> IncorrectMountTargetStateDeserializer().deserialize(context, wrappedCall, payload)
        "MountTargetNotFound" -> MountTargetNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "SecurityGroupLimitExceeded" -> SecurityGroupLimitExceededDeserializer().deserialize(context, wrappedCall, payload)
        "SecurityGroupNotFound" -> SecurityGroupNotFoundDeserializer().deserialize(context, wrappedCall, payload)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
