// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the destination file system in the replication configuration.
 */
public class Destination private constructor(builder: Builder) {
    /**
     * The ID of the destination Amazon EFS file system.
     */
    public val fileSystemId: kotlin.String = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }
    /**
     * The time when the most recent sync was successfully completed on the destination file system. Any changes to data on the source file system that occurred before this time have been successfully replicated to the destination file system. Any changes that occurred after this time might not be fully replicated.
     */
    public val lastReplicatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastReplicatedTimestamp
    /**
     * The Amazon Web Services Region in which the destination file system is located.
     */
    public val region: kotlin.String = requireNotNull(builder.region) { "A non-null value must be provided for region" }
    /**
     * Describes the status of the destination EFS file system.
     * + The `Paused` state occurs as a result of opting out of the source or destination Region after the replication configuration was created. To resume replication for the file system, you need to again opt in to the Amazon Web Services Region. For more information, see [Managing Amazon Web Services Regions](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable) in the *Amazon Web Services General Reference Guide*.
     * + The `Error` state occurs when either the source or the destination file system (or both) is in a failed state and is unrecoverable. For more information, see [Monitoring replication status](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html) in the *Amazon EFS User Guide*. You must delete the replication configuration, and then restore the most recent backup of the failed file system (either the source or the destination) to a new file system.
     */
    public val status: aws.sdk.kotlin.services.efs.model.ReplicationStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("fileSystemId=$fileSystemId,")
        append("lastReplicatedTimestamp=$lastReplicatedTimestamp,")
        append("region=$region,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId.hashCode()
        result = 31 * result + (lastReplicatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (region.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (fileSystemId != other.fileSystemId) return false
        if (lastReplicatedTimestamp != other.lastReplicatedTimestamp) return false
        if (region != other.region) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.Destination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the destination Amazon EFS file system.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The time when the most recent sync was successfully completed on the destination file system. Any changes to data on the source file system that occurred before this time have been successfully replicated to the destination file system. Any changes that occurred after this time might not be fully replicated.
         */
        public var lastReplicatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Region in which the destination file system is located.
         */
        public var region: kotlin.String? = null
        /**
         * Describes the status of the destination EFS file system.
         * + The `Paused` state occurs as a result of opting out of the source or destination Region after the replication configuration was created. To resume replication for the file system, you need to again opt in to the Amazon Web Services Region. For more information, see [Managing Amazon Web Services Regions](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable) in the *Amazon Web Services General Reference Guide*.
         * + The `Error` state occurs when either the source or the destination file system (or both) is in a failed state and is unrecoverable. For more information, see [Monitoring replication status](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html) in the *Amazon EFS User Guide*. You must delete the replication configuration, and then restore the most recent backup of the failed file system (either the source or the destination) to a new file system.
         */
        public var status: aws.sdk.kotlin.services.efs.model.ReplicationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.Destination) : this() {
            this.fileSystemId = x.fileSystemId
            this.lastReplicatedTimestamp = x.lastReplicatedTimestamp
            this.region = x.region
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.Destination = Destination(this)

        internal fun correctErrors(): Builder {
            if (fileSystemId == null) fileSystemId = ""
            if (region == null) region = ""
            if (status == null) status = ReplicationStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
