// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.DeleteFileSystemPolicyResponse
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteFileSystemPolicyOperationDeserializer: HttpDeserialize<DeleteFileSystemPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteFileSystemPolicyResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteFileSystemPolicyError(context, call)
        }
        val builder = DeleteFileSystemPolicyResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteFileSystemPolicyError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedCall)
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall)
        "IncorrectFileSystemLifeCycleState" -> IncorrectFileSystemLifeCycleStateDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
