// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.paginators

import aws.sdk.kotlin.services.efs.EfsClient
import aws.sdk.kotlin.services.efs.model.AccessPointDescription
import aws.sdk.kotlin.services.efs.model.DescribeAccessPointsRequest
import aws.sdk.kotlin.services.efs.model.DescribeAccessPointsResponse
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemsRequest
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemsResponse
import aws.sdk.kotlin.services.efs.model.DescribeMountTargetsRequest
import aws.sdk.kotlin.services.efs.model.DescribeMountTargetsResponse
import aws.sdk.kotlin.services.efs.model.DescribeReplicationConfigurationsRequest
import aws.sdk.kotlin.services.efs.model.DescribeReplicationConfigurationsResponse
import aws.sdk.kotlin.services.efs.model.DescribeTagsRequest
import aws.sdk.kotlin.services.efs.model.DescribeTagsResponse
import aws.sdk.kotlin.services.efs.model.FileSystemDescription
import aws.sdk.kotlin.services.efs.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.efs.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.efs.model.MountTargetDescription
import aws.sdk.kotlin.services.efs.model.ReplicationConfigurationDescription
import aws.sdk.kotlin.services.efs.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAccessPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccessPointsResponse]
 */
public fun EfsClient.describeAccessPointsPaginated(initialRequest: DescribeAccessPointsRequest = DescribeAccessPointsRequest { }): Flow<DescribeAccessPointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAccessPointsPaginated.describeAccessPoints(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccessPointsResponse]
 */
public fun EfsClient.describeAccessPointsPaginated(block: DescribeAccessPointsRequest.Builder.() -> Unit): Flow<DescribeAccessPointsResponse> =
    describeAccessPointsPaginated(DescribeAccessPointsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAccessPointsPaginated]
 * to access the nested member [AccessPointDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccessPointDescription]
 */
@JvmName("describeAccessPointsResponseAccessPointDescription")
public fun Flow<DescribeAccessPointsResponse>.accessPoints(): Flow<AccessPointDescription> =
    transform() { response ->
        response.accessPoints?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeFileSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFileSystemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemsResponse]
 */
public fun EfsClient.describeFileSystemsPaginated(initialRequest: DescribeFileSystemsRequest = DescribeFileSystemsRequest { }): Flow<DescribeFileSystemsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeFileSystemsPaginated.describeFileSystems(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFileSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemsResponse]
 */
public fun EfsClient.describeFileSystemsPaginated(block: DescribeFileSystemsRequest.Builder.() -> Unit): Flow<DescribeFileSystemsResponse> =
    describeFileSystemsPaginated(DescribeFileSystemsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeFileSystemsPaginated]
 * to access the nested member [FileSystemDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [FileSystemDescription]
 */
@JvmName("describeFileSystemsResponseFileSystemDescription")
public fun Flow<DescribeFileSystemsResponse>.fileSystems(): Flow<FileSystemDescription> =
    transform() { response ->
        response.fileSystems?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeMountTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMountTargetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMountTargetsResponse]
 */
public fun EfsClient.describeMountTargetsPaginated(initialRequest: DescribeMountTargetsRequest = DescribeMountTargetsRequest { }): Flow<DescribeMountTargetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeMountTargetsPaginated.describeMountTargets(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMountTargetsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMountTargetsResponse]
 */
public fun EfsClient.describeMountTargetsPaginated(block: DescribeMountTargetsRequest.Builder.() -> Unit): Flow<DescribeMountTargetsResponse> =
    describeMountTargetsPaginated(DescribeMountTargetsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeMountTargetsPaginated]
 * to access the nested member [MountTargetDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MountTargetDescription]
 */
@JvmName("describeMountTargetsResponseMountTargetDescription")
public fun Flow<DescribeMountTargetsResponse>.mountTargets(): Flow<MountTargetDescription> =
    transform() { response ->
        response.mountTargets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReplicationConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReplicationConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReplicationConfigurationsResponse]
 */
public fun EfsClient.describeReplicationConfigurationsPaginated(initialRequest: DescribeReplicationConfigurationsRequest = DescribeReplicationConfigurationsRequest { }): Flow<DescribeReplicationConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReplicationConfigurationsPaginated.describeReplicationConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReplicationConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReplicationConfigurationsResponse]
 */
public fun EfsClient.describeReplicationConfigurationsPaginated(block: DescribeReplicationConfigurationsRequest.Builder.() -> Unit): Flow<DescribeReplicationConfigurationsResponse> =
    describeReplicationConfigurationsPaginated(DescribeReplicationConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReplicationConfigurationsPaginated]
 * to access the nested member [ReplicationConfigurationDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReplicationConfigurationDescription]
 */
@JvmName("describeReplicationConfigurationsResponseReplicationConfigurationDescription")
public fun Flow<DescribeReplicationConfigurationsResponse>.replications(): Flow<ReplicationConfigurationDescription> =
    transform() { response ->
        response.replications?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun EfsClient.describeTagsPaginated(initialRequest: DescribeTagsRequest): Flow<DescribeTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTagsPaginated.describeTags(req)
            cursor = result.nextMarker
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
public fun EfsClient.describeTagsPaginated(block: DescribeTagsRequest.Builder.() -> Unit): Flow<DescribeTagsResponse> =
    describeTagsPaginated(DescribeTagsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeTagsPaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("describeTagsResponseTag")
public fun Flow<DescribeTagsResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun EfsClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun EfsClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())
