// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



/**
 * Provides a description of a mount target.
 */
public class CreateMountTargetResponse private constructor(builder: Builder) {
    /**
     * The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, `use1-az1` is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.
     */
    public val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone `us-east-1a` for your Amazon Web Services account might not be the same location as `us-east-1a` for another Amazon Web Services account.
     */
    public val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * The ID of the file system for which the mount target is intended.
     */
    public val fileSystemId: kotlin.String = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }
    /**
     * Address at which the file system can be mounted by using the mount target.
     */
    public val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Lifecycle state of the mount target.
     */
    public val lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState = requireNotNull(builder.lifeCycleState) { "A non-null value must be provided for lifeCycleState" }
    /**
     * System-assigned mount target ID.
     */
    public val mountTargetId: kotlin.String = requireNotNull(builder.mountTargetId) { "A non-null value must be provided for mountTargetId" }
    /**
     * The ID of the network interface that Amazon EFS created when it created the mount target.
     */
    public val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * Amazon Web Services account ID that owns the resource.
     */
    public val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the mount target's subnet.
     */
    public val subnetId: kotlin.String = requireNotNull(builder.subnetId) { "A non-null value must be provided for subnetId" }
    /**
     * The virtual private cloud (VPC) ID that the mount target is configured in.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMountTargetResponse(")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availabilityZoneName=$availabilityZoneName,")
        append("fileSystemId=$fileSystemId,")
        append("ipAddress=$ipAddress,")
        append("lifeCycleState=$lifeCycleState,")
        append("mountTargetId=$mountTargetId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("ownerId=$ownerId,")
        append("subnetId=$subnetId,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneId?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneName?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId.hashCode())
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (lifeCycleState.hashCode())
        result = 31 * result + (mountTargetId.hashCode())
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (subnetId.hashCode())
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMountTargetResponse

        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availabilityZoneName != other.availabilityZoneName) return false
        if (fileSystemId != other.fileSystemId) return false
        if (ipAddress != other.ipAddress) return false
        if (lifeCycleState != other.lifeCycleState) return false
        if (mountTargetId != other.mountTargetId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (ownerId != other.ownerId) return false
        if (subnetId != other.subnetId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, `use1-az1` is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.
         */
        public var availabilityZoneId: kotlin.String? = null
        /**
         * The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone `us-east-1a` for your Amazon Web Services account might not be the same location as `us-east-1a` for another Amazon Web Services account.
         */
        public var availabilityZoneName: kotlin.String? = null
        /**
         * The ID of the file system for which the mount target is intended.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * Address at which the file system can be mounted by using the mount target.
         */
        public var ipAddress: kotlin.String? = null
        /**
         * Lifecycle state of the mount target.
         */
        public var lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState? = null
        /**
         * System-assigned mount target ID.
         */
        public var mountTargetId: kotlin.String? = null
        /**
         * The ID of the network interface that Amazon EFS created when it created the mount target.
         */
        public var networkInterfaceId: kotlin.String? = null
        /**
         * Amazon Web Services account ID that owns the resource.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The ID of the mount target's subnet.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The virtual private cloud (VPC) ID that the mount target is configured in.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse) : this() {
            this.availabilityZoneId = x.availabilityZoneId
            this.availabilityZoneName = x.availabilityZoneName
            this.fileSystemId = x.fileSystemId
            this.ipAddress = x.ipAddress
            this.lifeCycleState = x.lifeCycleState
            this.mountTargetId = x.mountTargetId
            this.networkInterfaceId = x.networkInterfaceId
            this.ownerId = x.ownerId
            this.subnetId = x.subnetId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse = CreateMountTargetResponse(this)

        internal fun correctErrors(): Builder {
            if (fileSystemId == null) fileSystemId = ""
            if (lifeCycleState == null) lifeCycleState = LifeCycleState.SdkUnknown("no value provided")
            if (mountTargetId == null) mountTargetId = ""
            if (subnetId == null) subnetId = ""
            return this
        }
    }
}
