// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.CreateReplicationConfigurationResponse
import aws.sdk.kotlin.services.efs.model.Destination
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class CreateReplicationConfigurationOperationDeserializer: HttpDeserialize<CreateReplicationConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateReplicationConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateReplicationConfigurationError(context, call)
        }
        val builder = CreateReplicationConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateReplicationConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateReplicationConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedCall)
        "InsufficientThroughputCapacity" -> InsufficientThroughputCapacityDeserializer().deserialize(context, wrappedCall)
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall)
        "IncorrectFileSystemLifeCycleState" -> IncorrectFileSystemLifeCycleStateDeserializer().deserialize(context, wrappedCall)
        "FileSystemLimitExceeded" -> FileSystemLimitExceededDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThroughputLimitExceeded" -> ThroughputLimitExceededDeserializer().deserialize(context, wrappedCall)
        "ReplicationNotFound" -> ReplicationNotFoundDeserializer().deserialize(context, wrappedCall)
        "UnsupportedAvailabilityZone" -> UnsupportedAvailabilityZoneDeserializer().deserialize(context, wrappedCall)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateReplicationConfigurationOperationBody(builder: CreateReplicationConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationTime"))
    val DESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Destinations"))
    val ORIGINALSOURCEFILESYSTEMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OriginalSourceFileSystemArn"))
    val SOURCEFILESYSTEMARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceFileSystemArn"))
    val SOURCEFILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceFileSystemId"))
    val SOURCEFILESYSTEMREGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceFileSystemRegion"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESTINATIONS_DESCRIPTOR)
        field(ORIGINALSOURCEFILESYSTEMARN_DESCRIPTOR)
        field(SOURCEFILESYSTEMARN_DESCRIPTOR)
        field(SOURCEFILESYSTEMID_DESCRIPTOR)
        field(SOURCEFILESYSTEMREGION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESTINATIONS_DESCRIPTOR.index -> builder.destinations =
                    deserializer.deserializeList(DESTINATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<Destination>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDestinationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ORIGINALSOURCEFILESYSTEMARN_DESCRIPTOR.index -> builder.originalSourceFileSystemArn = deserializeString()
                SOURCEFILESYSTEMARN_DESCRIPTOR.index -> builder.sourceFileSystemArn = deserializeString()
                SOURCEFILESYSTEMID_DESCRIPTOR.index -> builder.sourceFileSystemId = deserializeString()
                SOURCEFILESYSTEMREGION_DESCRIPTOR.index -> builder.sourceFileSystemRegion = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
