// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.serde

import aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.sdk.kotlin.services.efs.model.LifeCycleState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateMountTargetOperationDeserializer: HttpDeserialize<CreateMountTargetResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateMountTargetResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateMountTargetError(context, call)
        }
        val builder = CreateMountTargetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateMountTargetOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateMountTargetError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedCall)
        "AvailabilityZonesMismatch" -> AvailabilityZonesMismatchDeserializer().deserialize(context, wrappedCall)
        "NoFreeAddressesInSubnet" -> NoFreeAddressesInSubnetDeserializer().deserialize(context, wrappedCall)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedCall)
        "IpAddressInUse" -> IpAddressInUseDeserializer().deserialize(context, wrappedCall)
        "IncorrectFileSystemLifeCycleState" -> IncorrectFileSystemLifeCycleStateDeserializer().deserialize(context, wrappedCall)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall)
        "SecurityGroupLimitExceeded" -> SecurityGroupLimitExceededDeserializer().deserialize(context, wrappedCall)
        "MountTargetConflict" -> MountTargetConflictDeserializer().deserialize(context, wrappedCall)
        "NetworkInterfaceLimitExceeded" -> NetworkInterfaceLimitExceededDeserializer().deserialize(context, wrappedCall)
        "SecurityGroupNotFound" -> SecurityGroupNotFoundDeserializer().deserialize(context, wrappedCall)
        "SubnetNotFound" -> SubnetNotFoundDeserializer().deserialize(context, wrappedCall)
        "UnsupportedAvailabilityZone" -> UnsupportedAvailabilityZoneDeserializer().deserialize(context, wrappedCall)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateMountTargetOperationBody(builder: CreateMountTargetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABILITYZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZoneId"))
    val AVAILABILITYZONENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZoneName"))
    val FILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemId"))
    val IPADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IpAddress"))
    val LIFECYCLESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("LifeCycleState"))
    val MOUNTTARGETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MountTargetId"))
    val NETWORKINTERFACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NetworkInterfaceId"))
    val OWNERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerId"))
    val SUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubnetId"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONEID_DESCRIPTOR)
        field(AVAILABILITYZONENAME_DESCRIPTOR)
        field(FILESYSTEMID_DESCRIPTOR)
        field(IPADDRESS_DESCRIPTOR)
        field(LIFECYCLESTATE_DESCRIPTOR)
        field(MOUNTTARGETID_DESCRIPTOR)
        field(NETWORKINTERFACEID_DESCRIPTOR)
        field(OWNERID_DESCRIPTOR)
        field(SUBNETID_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABILITYZONEID_DESCRIPTOR.index -> builder.availabilityZoneId = deserializeString()
                AVAILABILITYZONENAME_DESCRIPTOR.index -> builder.availabilityZoneName = deserializeString()
                FILESYSTEMID_DESCRIPTOR.index -> builder.fileSystemId = deserializeString()
                IPADDRESS_DESCRIPTOR.index -> builder.ipAddress = deserializeString()
                LIFECYCLESTATE_DESCRIPTOR.index -> builder.lifeCycleState = deserializeString().let { LifeCycleState.fromValue(it) }
                MOUNTTARGETID_DESCRIPTOR.index -> builder.mountTargetId = deserializeString()
                NETWORKINTERFACEID_DESCRIPTOR.index -> builder.networkInterfaceId = deserializeString()
                OWNERID_DESCRIPTOR.index -> builder.ownerId = deserializeString()
                SUBNETID_DESCRIPTOR.index -> builder.subnetId = deserializeString()
                VPCID_DESCRIPTOR.index -> builder.vpcId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
