// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the replication configuration for a specific file system.
 */
public class ReplicationConfigurationDescription private constructor(builder: Builder) {
    /**
     * Describes when the replication configuration was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * An array of destination objects. Only one destination object is supported.
     */
    public val destinations: List<Destination> = requireNotNull(builder.destinations) { "A non-null value must be provided for destinations" }
    /**
     * The Amazon Resource Name (ARN) of the original source EFS file system in the replication configuration.
     */
    public val originalSourceFileSystemArn: kotlin.String = requireNotNull(builder.originalSourceFileSystemArn) { "A non-null value must be provided for originalSourceFileSystemArn" }
    /**
     * The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
     */
    public val sourceFileSystemArn: kotlin.String = requireNotNull(builder.sourceFileSystemArn) { "A non-null value must be provided for sourceFileSystemArn" }
    /**
     * The ID of the source Amazon EFS file system that is being replicated.
     */
    public val sourceFileSystemId: kotlin.String = requireNotNull(builder.sourceFileSystemId) { "A non-null value must be provided for sourceFileSystemId" }
    /**
     * The Amazon Web Services Region in which the source EFS file system is located.
     */
    public val sourceFileSystemRegion: kotlin.String = requireNotNull(builder.sourceFileSystemRegion) { "A non-null value must be provided for sourceFileSystemRegion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.ReplicationConfigurationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicationConfigurationDescription(")
        append("creationTime=$creationTime,")
        append("destinations=$destinations,")
        append("originalSourceFileSystemArn=$originalSourceFileSystemArn,")
        append("sourceFileSystemArn=$sourceFileSystemArn,")
        append("sourceFileSystemId=$sourceFileSystemId,")
        append("sourceFileSystemRegion=$sourceFileSystemRegion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime.hashCode()
        result = 31 * result + (destinations.hashCode())
        result = 31 * result + (originalSourceFileSystemArn.hashCode())
        result = 31 * result + (sourceFileSystemArn.hashCode())
        result = 31 * result + (sourceFileSystemId.hashCode())
        result = 31 * result + (sourceFileSystemRegion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicationConfigurationDescription

        if (creationTime != other.creationTime) return false
        if (destinations != other.destinations) return false
        if (originalSourceFileSystemArn != other.originalSourceFileSystemArn) return false
        if (sourceFileSystemArn != other.sourceFileSystemArn) return false
        if (sourceFileSystemId != other.sourceFileSystemId) return false
        if (sourceFileSystemRegion != other.sourceFileSystemRegion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.ReplicationConfigurationDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes when the replication configuration was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of destination objects. Only one destination object is supported.
         */
        public var destinations: List<Destination>? = null
        /**
         * The Amazon Resource Name (ARN) of the original source EFS file system in the replication configuration.
         */
        public var originalSourceFileSystemArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the current source file system in the replication configuration.
         */
        public var sourceFileSystemArn: kotlin.String? = null
        /**
         * The ID of the source Amazon EFS file system that is being replicated.
         */
        public var sourceFileSystemId: kotlin.String? = null
        /**
         * The Amazon Web Services Region in which the source EFS file system is located.
         */
        public var sourceFileSystemRegion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.ReplicationConfigurationDescription) : this() {
            this.creationTime = x.creationTime
            this.destinations = x.destinations
            this.originalSourceFileSystemArn = x.originalSourceFileSystemArn
            this.sourceFileSystemArn = x.sourceFileSystemArn
            this.sourceFileSystemId = x.sourceFileSystemId
            this.sourceFileSystemRegion = x.sourceFileSystemRegion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.ReplicationConfigurationDescription = ReplicationConfigurationDescription(this)

        internal fun correctErrors(): Builder {
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (destinations == null) destinations = emptyList()
            if (originalSourceFileSystemArn == null) originalSourceFileSystemArn = ""
            if (sourceFileSystemArn == null) sourceFileSystemArn = ""
            if (sourceFileSystemId == null) sourceFileSystemId = ""
            if (sourceFileSystemRegion == null) sourceFileSystemRegion = ""
            return this
        }
    }
}
