// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



/**
 * The full POSIX identity, including the user ID, group ID, and any secondary group IDs, on the access point that is used for all file system operations performed by NFS clients using the access point.
 */
public class PosixUser private constructor(builder: Builder) {
    /**
     * The POSIX group ID used for all file system operations using this access point.
     */
    public val gid: kotlin.Long = requireNotNull(builder.gid) { "A non-null value must be provided for gid" }
    /**
     * Secondary POSIX group IDs used for all file system operations using this access point.
     */
    public val secondaryGids: List<Long>? = builder.secondaryGids
    /**
     * The POSIX user ID used for all file system operations using this access point.
     */
    public val uid: kotlin.Long = requireNotNull(builder.uid) { "A non-null value must be provided for uid" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.PosixUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PosixUser(")
        append("gid=$gid,")
        append("secondaryGids=$secondaryGids,")
        append("uid=$uid")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = gid.hashCode()
        result = 31 * result + (secondaryGids?.hashCode() ?: 0)
        result = 31 * result + (uid.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PosixUser

        if (gid != other.gid) return false
        if (secondaryGids != other.secondaryGids) return false
        if (uid != other.uid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.PosixUser = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The POSIX group ID used for all file system operations using this access point.
         */
        public var gid: kotlin.Long? = null
        /**
         * Secondary POSIX group IDs used for all file system operations using this access point.
         */
        public var secondaryGids: List<Long>? = null
        /**
         * The POSIX user ID used for all file system operations using this access point.
         */
        public var uid: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.PosixUser) : this() {
            this.gid = x.gid
            this.secondaryGids = x.secondaryGids
            this.uid = x.uid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.PosixUser = PosixUser(this)

        internal fun correctErrors(): Builder {
            if (gid == null) gid = 0L
            if (uid == null) uid = 0L
            return this
        }
    }
}
