// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



/**
 * Describes a policy used by Lifecycle management that specifies when to transition files into and out of storage classes. For more information, see [Managing file system storage](https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html).
 *
 * When using the `put-lifecycle-configuration` CLI command or the `PutLifecycleConfiguration` API action, Amazon EFS requires that each `LifecyclePolicy` object have only a single transition. This means that in a request body, `LifecyclePolicies` must be structured as an array of `LifecyclePolicy` objects, one object for each transition. For more information, see the request examples in PutLifecycleConfiguration.
 */
public class LifecyclePolicy private constructor(builder: Builder) {
    /**
     * The number of days after files were last accessed in primary storage (the Standard storage class) files at which to move them to Archive storage. Metadata operations such as listing the contents of a directory don't count as file access events.
     */
    public val transitionToArchive: aws.sdk.kotlin.services.efs.model.TransitionToArchiveRules? = builder.transitionToArchive
    /**
     * The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Infrequent Access (IA) storage. Metadata operations such as listing the contents of a directory don't count as file access events.
     */
    public val transitionToIa: aws.sdk.kotlin.services.efs.model.TransitionToIaRules? = builder.transitionToIa
    /**
     * Whether to move files back to primary (Standard) storage after they are accessed in IA or Archive storage. Metadata operations such as listing the contents of a directory don't count as file access events.
     */
    public val transitionToPrimaryStorageClass: aws.sdk.kotlin.services.efs.model.TransitionToPrimaryStorageClassRules? = builder.transitionToPrimaryStorageClass

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.LifecyclePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicy(")
        append("transitionToArchive=$transitionToArchive,")
        append("transitionToIa=$transitionToIa,")
        append("transitionToPrimaryStorageClass=$transitionToPrimaryStorageClass")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = transitionToArchive?.hashCode() ?: 0
        result = 31 * result + (transitionToIa?.hashCode() ?: 0)
        result = 31 * result + (transitionToPrimaryStorageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicy

        if (transitionToArchive != other.transitionToArchive) return false
        if (transitionToIa != other.transitionToIa) return false
        if (transitionToPrimaryStorageClass != other.transitionToPrimaryStorageClass) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.LifecyclePolicy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The number of days after files were last accessed in primary storage (the Standard storage class) files at which to move them to Archive storage. Metadata operations such as listing the contents of a directory don't count as file access events.
         */
        public var transitionToArchive: aws.sdk.kotlin.services.efs.model.TransitionToArchiveRules? = null
        /**
         * The number of days after files were last accessed in primary storage (the Standard storage class) at which to move them to Infrequent Access (IA) storage. Metadata operations such as listing the contents of a directory don't count as file access events.
         */
        public var transitionToIa: aws.sdk.kotlin.services.efs.model.TransitionToIaRules? = null
        /**
         * Whether to move files back to primary (Standard) storage after they are accessed in IA or Archive storage. Metadata operations such as listing the contents of a directory don't count as file access events.
         */
        public var transitionToPrimaryStorageClass: aws.sdk.kotlin.services.efs.model.TransitionToPrimaryStorageClassRules? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.LifecyclePolicy) : this() {
            this.transitionToArchive = x.transitionToArchive
            this.transitionToIa = x.transitionToIa
            this.transitionToPrimaryStorageClass = x.transitionToPrimaryStorageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.LifecyclePolicy = LifecyclePolicy(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
