// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.transform

import aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutFileSystemPolicyOperationSerializer: HttpSerialize<PutFileSystemPolicyRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutFileSystemPolicyRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "2015-02-01",
                "file-systems",
                "${input.fileSystemId}".encodeLabel(),
                "policy",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializePutFileSystemPolicyOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutFileSystemPolicyOperationBody(context: ExecutionContext, input: PutFileSystemPolicyRequest): ByteArray {
    val serializer = JsonSerializer()
    val BYPASSPOLICYLOCKOUTSAFETYCHECK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("BypassPolicyLockoutSafetyCheck"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Policy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BYPASSPOLICYLOCKOUTSAFETYCHECK_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.bypassPolicyLockoutSafetyCheck != false) field(BYPASSPOLICYLOCKOUTSAFETYCHECK_DESCRIPTOR, input.bypassPolicyLockoutSafetyCheck)
        input.policy?.let { field(POLICY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
