// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.sdk.kotlin.services.efs.model.PutFileSystemPolicyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutFileSystemPolicyOperationDeserializer: HttpDeserialize<PutFileSystemPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutFileSystemPolicyResponse {
        if (!response.status.isSuccess()) {
            throwPutFileSystemPolicyError(context, response)
        }
        val builder = PutFileSystemPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutFileSystemPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutFileSystemPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedResponse)
        "IncorrectFileSystemLifeCycleState" -> IncorrectFileSystemLifeCycleStateDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidPolicyException" -> InvalidPolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutFileSystemPolicyOperationBody(builder: PutFileSystemPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemId"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Policy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILESYSTEMID_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FILESYSTEMID_DESCRIPTOR.index -> builder.fileSystemId = deserializeString()
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
