// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.efs.model.DescribeLifecycleConfigurationResponse
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.sdk.kotlin.services.efs.model.LifecyclePolicy
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeLifecycleConfigurationOperationDeserializer: HttpDeserialize<DescribeLifecycleConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeLifecycleConfigurationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeLifecycleConfigurationError(context, response)
        }
        val builder = DescribeLifecycleConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeLifecycleConfigurationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeLifecycleConfigurationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeLifecycleConfigurationOperationBody(builder: DescribeLifecycleConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LIFECYCLEPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("LifecyclePolicies"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LIFECYCLEPOLICIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LIFECYCLEPOLICIES_DESCRIPTOR.index -> builder.lifecyclePolicies =
                    deserializer.deserializeList(LIFECYCLEPOLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<LifecyclePolicy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLifecyclePolicyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
