// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



public class UpdateFileSystemRequest private constructor(builder: Builder) {
    /**
     * The ID of the file system that you want to update.
     */
    public val fileSystemId: kotlin.String? = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }
    /**
     * (Optional) Sets the amount of provisioned throughput, in MiB/s, for the file system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also provide the amount of provisioned throughput. Required if `ThroughputMode` is changed to `provisioned` on update.
     */
    public val provisionedThroughputInMibps: kotlin.Double? = builder.provisionedThroughputInMibps
    /**
     * (Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`.
     */
    public val throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = builder.throughputMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateFileSystemRequest(")
        append("fileSystemId=$fileSystemId,")
        append("provisionedThroughputInMibps=$provisionedThroughputInMibps,")
        append("throughputMode=$throughputMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (provisionedThroughputInMibps?.hashCode() ?: 0)
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateFileSystemRequest

        if (fileSystemId != other.fileSystemId) return false
        if (provisionedThroughputInMibps != other.provisionedThroughputInMibps) return false
        if (throughputMode != other.throughputMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the file system that you want to update.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * (Optional) Sets the amount of provisioned throughput, in MiB/s, for the file system. Valid values are 1-1024. If you are changing the throughput mode to provisioned, you must also provide the amount of provisioned throughput. Required if `ThroughputMode` is changed to `provisioned` on update.
         */
        public var provisionedThroughputInMibps: kotlin.Double? = null
        /**
         * (Optional) Updates the file system's throughput mode. If you're not updating your throughput mode, you don't need to provide this value in your request. If you are changing the `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`.
         */
        public var throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest) : this() {
            this.fileSystemId = x.fileSystemId
            this.provisionedThroughputInMibps = x.provisionedThroughputInMibps
            this.throughputMode = x.throughputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.UpdateFileSystemRequest = UpdateFileSystemRequest(this)
    }
}
