// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the destination file system in the replication configuration.
 */
public class Destination private constructor(builder: Builder) {
    /**
     * The ID of the destination Amazon EFS file system.
     */
    public val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * The time when the most recent sync was successfully completed on the destination file system. Any changes to data on the source file system that occurred before this time have been successfully replicated to the destination file system. Any changes that occurred after this time might not be fully replicated.
     */
    public val lastReplicatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastReplicatedTimestamp
    /**
     * The Amazon Web Services Region in which the destination file system is located.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Describes the status of the destination Amazon EFS file system. If the status is `ERROR`, the destination file system in the replication configuration is in a failed state and is unrecoverable. To access the file system data, restore a backup of the failed file system to a new file system.
     */
    public val status: aws.sdk.kotlin.services.efs.model.ReplicationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Destination(")
        append("fileSystemId=$fileSystemId,")
        append("lastReplicatedTimestamp=$lastReplicatedTimestamp,")
        append("region=$region,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (lastReplicatedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Destination

        if (fileSystemId != other.fileSystemId) return false
        if (lastReplicatedTimestamp != other.lastReplicatedTimestamp) return false
        if (region != other.region) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.Destination = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the destination Amazon EFS file system.
         */
        public var fileSystemId: kotlin.String? = null
        /**
         * The time when the most recent sync was successfully completed on the destination file system. Any changes to data on the source file system that occurred before this time have been successfully replicated to the destination file system. Any changes that occurred after this time might not be fully replicated.
         */
        public var lastReplicatedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Region in which the destination file system is located.
         */
        public var region: kotlin.String? = null
        /**
         * Describes the status of the destination Amazon EFS file system. If the status is `ERROR`, the destination file system in the replication configuration is in a failed state and is unrecoverable. To access the file system data, restore a backup of the failed file system to a new file system.
         */
        public var status: aws.sdk.kotlin.services.efs.model.ReplicationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.Destination) : this() {
            this.fileSystemId = x.fileSystemId
            this.lastReplicatedTimestamp = x.lastReplicatedTimestamp
            this.region = x.region
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.Destination = Destination(this)
    }
}
