// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.sdk.kotlin.services.efs.model.LifeCycleState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateMountTargetOperationDeserializer: HttpDeserialize<CreateMountTargetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateMountTargetResponse {
        if (!response.status.isSuccess()) {
            throwCreateMountTargetError(context, response)
        }
        val builder = CreateMountTargetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateMountTargetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateMountTargetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AvailabilityZonesMismatch" -> AvailabilityZonesMismatchDeserializer().deserialize(context, wrappedResponse)
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedResponse)
        "IncorrectFileSystemLifeCycleState" -> IncorrectFileSystemLifeCycleStateDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "IpAddressInUse" -> IpAddressInUseDeserializer().deserialize(context, wrappedResponse)
        "MountTargetConflict" -> MountTargetConflictDeserializer().deserialize(context, wrappedResponse)
        "NetworkInterfaceLimitExceeded" -> NetworkInterfaceLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "NoFreeAddressesInSubnet" -> NoFreeAddressesInSubnetDeserializer().deserialize(context, wrappedResponse)
        "SecurityGroupLimitExceeded" -> SecurityGroupLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "SecurityGroupNotFound" -> SecurityGroupNotFoundDeserializer().deserialize(context, wrappedResponse)
        "SubnetNotFound" -> SubnetNotFoundDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedAvailabilityZone" -> UnsupportedAvailabilityZoneDeserializer().deserialize(context, wrappedResponse)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateMountTargetOperationBody(builder: CreateMountTargetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AVAILABILITYZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZoneId"))
    val AVAILABILITYZONENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AvailabilityZoneName"))
    val FILESYSTEMID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FileSystemId"))
    val IPADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IpAddress"))
    val LIFECYCLESTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LifeCycleState"))
    val MOUNTTARGETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MountTargetId"))
    val NETWORKINTERFACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NetworkInterfaceId"))
    val OWNERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerId"))
    val SUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SubnetId"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AVAILABILITYZONEID_DESCRIPTOR)
        field(AVAILABILITYZONENAME_DESCRIPTOR)
        field(FILESYSTEMID_DESCRIPTOR)
        field(IPADDRESS_DESCRIPTOR)
        field(LIFECYCLESTATE_DESCRIPTOR)
        field(MOUNTTARGETID_DESCRIPTOR)
        field(NETWORKINTERFACEID_DESCRIPTOR)
        field(OWNERID_DESCRIPTOR)
        field(SUBNETID_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABILITYZONEID_DESCRIPTOR.index -> builder.availabilityZoneId = deserializeString()
                AVAILABILITYZONENAME_DESCRIPTOR.index -> builder.availabilityZoneName = deserializeString()
                FILESYSTEMID_DESCRIPTOR.index -> builder.fileSystemId = deserializeString()
                IPADDRESS_DESCRIPTOR.index -> builder.ipAddress = deserializeString()
                LIFECYCLESTATE_DESCRIPTOR.index -> builder.lifeCycleState = deserializeString().let { LifeCycleState.fromValue(it) }
                MOUNTTARGETID_DESCRIPTOR.index -> builder.mountTargetId = deserializeString()
                NETWORKINTERFACEID_DESCRIPTOR.index -> builder.networkInterfaceId = deserializeString()
                OWNERID_DESCRIPTOR.index -> builder.ownerId = deserializeString()
                SUBNETID_DESCRIPTOR.index -> builder.subnetId = deserializeString()
                VPCID_DESCRIPTOR.index -> builder.vpcId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
