// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.paginators

import aws.sdk.kotlin.services.efs.EfsClient
import aws.sdk.kotlin.services.efs.model.DescribeAccessPointsRequest
import aws.sdk.kotlin.services.efs.model.DescribeAccessPointsResponse
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemsRequest
import aws.sdk.kotlin.services.efs.model.DescribeFileSystemsResponse
import aws.sdk.kotlin.services.efs.model.DescribeTagsRequest
import aws.sdk.kotlin.services.efs.model.DescribeTagsResponse
import aws.sdk.kotlin.services.efs.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.efs.model.ListTagsForResourceResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAccessPointsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccessPointsResponse]
 */
fun EfsClient.describeAccessPointsPaginated(initialRequest: DescribeAccessPointsRequest): Flow<DescribeAccessPointsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAccessPointsPaginated.describeAccessPoints(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAccessPointsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAccessPointsResponse]
 */
fun EfsClient.describeAccessPointsPaginated(block: DescribeAccessPointsRequest.Builder.() -> Unit): Flow<DescribeAccessPointsResponse> =
    describeAccessPointsPaginated(DescribeAccessPointsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFileSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFileSystemsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemsResponse]
 */
fun EfsClient.describeFileSystemsPaginated(initialRequest: DescribeFileSystemsRequest): Flow<DescribeFileSystemsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeFileSystemsPaginated.describeFileSystems(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFileSystemsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFileSystemsResponse]
 */
fun EfsClient.describeFileSystemsPaginated(block: DescribeFileSystemsRequest.Builder.() -> Unit): Flow<DescribeFileSystemsResponse> =
    describeFileSystemsPaginated(DescribeFileSystemsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeTagsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
fun EfsClient.describeTagsPaginated(initialRequest: DescribeTagsRequest): Flow<DescribeTagsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeTagsPaginated.describeTags(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeTagsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeTagsResponse]
 */
fun EfsClient.describeTagsPaginated(block: DescribeTagsRequest.Builder.() -> Unit): Flow<DescribeTagsResponse> =
    describeTagsPaginated(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun EfsClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun EfsClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())
