// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



/**
 * Describes a policy used by EFS lifecycle management and EFS Intelligent-Tiering that specifies when to transition files into and out of the file system's Infrequent Access (IA) storage class. For more information, see [EFS Intelligent‐Tiering and EFS Lifecycle Management](https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html).
 *
 * When using the `put-lifecycle-configuration` CLI command or the `PutLifecycleConfiguration` API action, Amazon EFS requires that each `LifecyclePolicy` object have only a single transition. This means that in a request body, `LifecyclePolicies` must be structured as an array of `LifecyclePolicy` objects, one object for each transition, `TransitionToIA`, `TransitionToPrimaryStorageClass`. For more information, see the request examples in PutLifecycleConfiguration.
 */
class LifecyclePolicy private constructor(builder: Builder) {
    /**
     * Describes the period of time that a file is not accessed, after which it transitions to IA storage. Metadata operations such as listing the contents of a directory don't count as file access events.
     */
    val transitionToIa: aws.sdk.kotlin.services.efs.model.TransitionToIaRules? = builder.transitionToIa
    /**
     * Describes when to transition a file from IA storage to primary storage. Metadata operations such as listing the contents of a directory don't count as file access events.
     */
    val transitionToPrimaryStorageClass: aws.sdk.kotlin.services.efs.model.TransitionToPrimaryStorageClassRules? = builder.transitionToPrimaryStorageClass

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.LifecyclePolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecyclePolicy(")
        append("transitionToIa=$transitionToIa,")
        append("transitionToPrimaryStorageClass=$transitionToPrimaryStorageClass)")
    }

    override fun hashCode(): kotlin.Int {
        var result = transitionToIa?.hashCode() ?: 0
        result = 31 * result + (transitionToPrimaryStorageClass?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecyclePolicy

        if (transitionToIa != other.transitionToIa) return false
        if (transitionToPrimaryStorageClass != other.transitionToPrimaryStorageClass) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.LifecyclePolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * Describes the period of time that a file is not accessed, after which it transitions to IA storage. Metadata operations such as listing the contents of a directory don't count as file access events.
         */
        var transitionToIa: aws.sdk.kotlin.services.efs.model.TransitionToIaRules? = null
        /**
         * Describes when to transition a file from IA storage to primary storage. Metadata operations such as listing the contents of a directory don't count as file access events.
         */
        var transitionToPrimaryStorageClass: aws.sdk.kotlin.services.efs.model.TransitionToPrimaryStorageClassRules? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.LifecyclePolicy) : this() {
            this.transitionToIa = x.transitionToIa
            this.transitionToPrimaryStorageClass = x.transitionToPrimaryStorageClass
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.LifecyclePolicy = LifecyclePolicy(this)
    }
}
