// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateServiceRequest private constructor(builder: Builder) {
    /**
     * The capacity provider strategy to update the service to use.
     *
     * if the service uses the default capacity provider strategy for the cluster, the service can be updated to use one or more capacity providers as opposed to the default capacity provider strategy. However, when a service is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be updated to use the cluster's default capacity provider strategy.
     *
     * A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
     *
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
     *
     * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     *
     * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    public val deploymentConfiguration: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration? = builder.deploymentConfiguration
    /**
     * The number of instantiations of the task to place and keep running in your service.
     */
    public val desiredCount: kotlin.Int? = builder.desiredCount
    /**
     * Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set `forceNewDeployment` to `true`, so that Amazon ECS starts new tasks with the updated tags.
     */
    public val enableEcsManagedTags: kotlin.Boolean? = builder.enableEcsManagedTags
    /**
     * If `true`, this enables execute command functionality on all task containers.
     *
     * If you do not want to override the value that was set when the service was created, you can set this to `null` when performing this action.
     */
    public val enableExecuteCommand: kotlin.Boolean? = builder.enableExecuteCommand
    /**
     * Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can use this option to start a new deployment with no service definition changes. For example, you can update a service's tasks to use a newer Docker image with the same image/tag combination (`my_image:latest`) or to roll Fargate tasks onto a newer platform version.
     */
    public val forceNewDeployment: kotlin.Boolean? = builder.forceNewDeployment
    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid if your service is configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
     */
    public val healthCheckGracePeriodSeconds: kotlin.Int? = builder.healthCheckGracePeriodSeconds
    /**
     * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name, and the container port to access from the load balancer. The container name is as it appears in a container definition.
     *
     * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
     *
     * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups. You can update from a single target group to multiple target groups and from multiple target groups to a single target group.
     *
     * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using ` <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> ` through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more information see [Register multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * For services that use the external deployment controller, you can add, update, or remove load balancers by using [CreateTaskSet](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html). Note that multiple target groups are not supported for external deployments. For more information see [Register multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * You can remove existing `loadBalancers` by passing an empty list.
     */
    public val loadBalancers: List<LoadBalancer>? = builder.loadBalancers
    /**
     * An object representing the network configuration for the service.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * An array of task placement constraint objects to update the service to use. If no value is specified, the existing placement constraints for the service will remain unchanged. If this value is specified, it will override any existing placement constraints defined for the service. To remove all existing placement constraints, specify an empty array.
     *
     * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
     */
    public val placementConstraints: List<PlacementConstraint>? = builder.placementConstraints
    /**
     * The task placement strategy objects to update the service to use. If no value is specified, the existing placement strategy for the service will remain unchanged. If this value is specified, it will override the existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty object.
     *
     * You can specify a maximum of five strategy rules for each service.
     */
    public val placementStrategy: List<PlacementStrategy>? = builder.placementStrategy
    /**
     * The platform version that your tasks in the service run on. A platform version is only specified for tasks using the Fargate launch type. If a platform version is not specified, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * Determines whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.
     *
     * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set `forceNewDeployment` to `true`, so that Amazon ECS starts new tasks with the updated tags.
     */
    public val propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = builder.propagateTags
    /**
     * The name of the service to update.
     */
    public val service: kotlin.String? = builder.service
    /**
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     *
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val serviceConnectConfiguration: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration? = builder.serviceConnectConfiguration
    /**
     * The details for the service discovery registries to assign to this service. For more information, see [Service Discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
     *
     * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the updated service registries configuration, and then stops the old tasks when the new tasks are running.
     *
     * You can remove existing `serviceRegistries` by passing an empty list.
     */
    public val serviceRegistries: List<ServiceRegistry>? = builder.serviceRegistries
    /**
     * The `family` and `revision` (`family:revision`) or full ARN of the task definition to run in your service. If a `revision` is not specified, the latest `ACTIVE` revision is used. If you modify the task definition with `UpdateService`, Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new version is running.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition
    /**
     * The details of the volume that was `configuredAtLaunch`. You can configure the size, volumeType, IOPS, throughput, snapshot and encryption in [ServiceManagedEBSVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html). The `name` of the volume must match the `name` from the task definition. If set to null, no new deployment is triggered. Otherwise, if this configuration differs from the existing one, it triggers a new deployment.
     */
    public val volumeConfigurations: List<ServiceVolumeConfiguration>? = builder.volumeConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.UpdateServiceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateServiceRequest(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("cluster=$cluster,")
        append("deploymentConfiguration=$deploymentConfiguration,")
        append("desiredCount=$desiredCount,")
        append("enableEcsManagedTags=$enableEcsManagedTags,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("forceNewDeployment=$forceNewDeployment,")
        append("healthCheckGracePeriodSeconds=$healthCheckGracePeriodSeconds,")
        append("loadBalancers=$loadBalancers,")
        append("networkConfiguration=$networkConfiguration,")
        append("placementConstraints=$placementConstraints,")
        append("placementStrategy=$placementStrategy,")
        append("platformVersion=$platformVersion,")
        append("propagateTags=$propagateTags,")
        append("service=$service,")
        append("serviceConnectConfiguration=$serviceConnectConfiguration,")
        append("serviceRegistries=$serviceRegistries,")
        append("taskDefinition=$taskDefinition,")
        append("volumeConfigurations=$volumeConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (desiredCount ?: 0)
        result = 31 * result + (enableEcsManagedTags?.hashCode() ?: 0)
        result = 31 * result + (enableExecuteCommand?.hashCode() ?: 0)
        result = 31 * result + (forceNewDeployment?.hashCode() ?: 0)
        result = 31 * result + (healthCheckGracePeriodSeconds ?: 0)
        result = 31 * result + (loadBalancers?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (placementConstraints?.hashCode() ?: 0)
        result = 31 * result + (placementStrategy?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (serviceConnectConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceRegistries?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        result = 31 * result + (volumeConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateServiceRequest

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (cluster != other.cluster) return false
        if (deploymentConfiguration != other.deploymentConfiguration) return false
        if (desiredCount != other.desiredCount) return false
        if (enableEcsManagedTags != other.enableEcsManagedTags) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (forceNewDeployment != other.forceNewDeployment) return false
        if (healthCheckGracePeriodSeconds != other.healthCheckGracePeriodSeconds) return false
        if (loadBalancers != other.loadBalancers) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (placementConstraints != other.placementConstraints) return false
        if (placementStrategy != other.placementStrategy) return false
        if (platformVersion != other.platformVersion) return false
        if (propagateTags != other.propagateTags) return false
        if (service != other.service) return false
        if (serviceConnectConfiguration != other.serviceConnectConfiguration) return false
        if (serviceRegistries != other.serviceRegistries) return false
        if (taskDefinition != other.taskDefinition) return false
        if (volumeConfigurations != other.volumeConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.UpdateServiceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The capacity provider strategy to update the service to use.
         *
         * if the service uses the default capacity provider strategy for the cluster, the service can be updated to use one or more capacity providers as opposed to the default capacity provider strategy. However, when a service is using a capacity provider strategy that's not the default capacity provider strategy, the service can't be updated to use the cluster's default capacity provider strategy.
         *
         * A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
         *
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
         *
         * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         *
         * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that your service runs on. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
         */
        public var deploymentConfiguration: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration? = null
        /**
         * The number of instantiations of the task to place and keep running in your service.
         */
        public var desiredCount: kotlin.Int? = null
        /**
         * Determines whether to turn on Amazon ECS managed tags for the tasks in the service. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set `forceNewDeployment` to `true`, so that Amazon ECS starts new tasks with the updated tags.
         */
        public var enableEcsManagedTags: kotlin.Boolean? = null
        /**
         * If `true`, this enables execute command functionality on all task containers.
         *
         * If you do not want to override the value that was set when the service was created, you can set this to `null` when performing this action.
         */
        public var enableExecuteCommand: kotlin.Boolean? = null
        /**
         * Determines whether to force a new deployment of the service. By default, deployments aren't forced. You can use this option to start a new deployment with no service definition changes. For example, you can update a service's tasks to use a newer Docker image with the same image/tag combination (`my_image:latest`) or to roll Fargate tasks onto a newer platform version.
         */
        public var forceNewDeployment: kotlin.Boolean? = null
        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This is only valid if your service is configured to use a load balancer. If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds. During that time, the Amazon ECS service scheduler ignores the Elastic Load Balancing health check status. This grace period can prevent the ECS service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
         */
        public var healthCheckGracePeriodSeconds: kotlin.Int? = null
        /**
         * A list of Elastic Load Balancing load balancer objects. It contains the load balancer name, the container name, and the container port to access from the load balancer. The container name is as it appears in a container definition.
         *
         * When you add, update, or remove a load balancer configuration, Amazon ECS starts new tasks with the updated Elastic Load Balancing configuration, and then stops the old tasks when the new tasks are running.
         *
         * For services that use rolling updates, you can add, update, or remove Elastic Load Balancing target groups. You can update from a single target group to multiple target groups and from multiple target groups to a single target group.
         *
         * For services that use blue/green deployments, you can update Elastic Load Balancing target groups by using ` <a href="https://docs.aws.amazon.com/codedeploy/latest/APIReference/API_CreateDeployment.html">CreateDeployment</a> ` through CodeDeploy. Note that multiple target groups are not supported for blue/green deployments. For more information see [Register multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * For services that use the external deployment controller, you can add, update, or remove load balancers by using [CreateTaskSet](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateTaskSet.html). Note that multiple target groups are not supported for external deployments. For more information see [Register multiple target groups with a service](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * You can remove existing `loadBalancers` by passing an empty list.
         */
        public var loadBalancers: List<LoadBalancer>? = null
        /**
         * An object representing the network configuration for the service.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * An array of task placement constraint objects to update the service to use. If no value is specified, the existing placement constraints for the service will remain unchanged. If this value is specified, it will override any existing placement constraints defined for the service. To remove all existing placement constraints, specify an empty array.
         *
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
         */
        public var placementConstraints: List<PlacementConstraint>? = null
        /**
         * The task placement strategy objects to update the service to use. If no value is specified, the existing placement strategy for the service will remain unchanged. If this value is specified, it will override the existing placement strategy defined for the service. To remove an existing placement strategy, specify an empty object.
         *
         * You can specify a maximum of five strategy rules for each service.
         */
        public var placementStrategy: List<PlacementStrategy>? = null
        /**
         * The platform version that your tasks in the service run on. A platform version is only specified for tasks using the Fargate launch type. If a platform version is not specified, the `LATEST` platform version is used. For more information, see [Fargate Platform Versions](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * Determines whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.
         *
         * Only tasks launched after the update will reflect the update. To update the tags on all tasks, set `forceNewDeployment` to `true`, so that Amazon ECS starts new tasks with the updated tags.
         */
        public var propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = null
        /**
         * The name of the service to update.
         */
        public var service: kotlin.String? = null
        /**
         * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
         *
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var serviceConnectConfiguration: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration? = null
        /**
         * The details for the service discovery registries to assign to this service. For more information, see [Service Discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
         *
         * When you add, update, or remove the service registries configuration, Amazon ECS starts new tasks with the updated service registries configuration, and then stops the old tasks when the new tasks are running.
         *
         * You can remove existing `serviceRegistries` by passing an empty list.
         */
        public var serviceRegistries: List<ServiceRegistry>? = null
        /**
         * The `family` and `revision` (`family:revision`) or full ARN of the task definition to run in your service. If a `revision` is not specified, the latest `ACTIVE` revision is used. If you modify the task definition with `UpdateService`, Amazon ECS spawns a task with the new version of the task definition and then stops an old task after the new version is running.
         */
        public var taskDefinition: kotlin.String? = null
        /**
         * The details of the volume that was `configuredAtLaunch`. You can configure the size, volumeType, IOPS, throughput, snapshot and encryption in [ServiceManagedEBSVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ServiceManagedEBSVolumeConfiguration.html). The `name` of the volume must match the `name` from the task definition. If set to null, no new deployment is triggered. Otherwise, if this configuration differs from the existing one, it triggers a new deployment.
         */
        public var volumeConfigurations: List<ServiceVolumeConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.UpdateServiceRequest) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.cluster = x.cluster
            this.deploymentConfiguration = x.deploymentConfiguration
            this.desiredCount = x.desiredCount
            this.enableEcsManagedTags = x.enableEcsManagedTags
            this.enableExecuteCommand = x.enableExecuteCommand
            this.forceNewDeployment = x.forceNewDeployment
            this.healthCheckGracePeriodSeconds = x.healthCheckGracePeriodSeconds
            this.loadBalancers = x.loadBalancers
            this.networkConfiguration = x.networkConfiguration
            this.placementConstraints = x.placementConstraints
            this.placementStrategy = x.placementStrategy
            this.platformVersion = x.platformVersion
            this.propagateTags = x.propagateTags
            this.service = x.service
            this.serviceConnectConfiguration = x.serviceConnectConfiguration
            this.serviceRegistries = x.serviceRegistries
            this.taskDefinition = x.taskDefinition
            this.volumeConfigurations = x.volumeConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.UpdateServiceRequest = UpdateServiceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration] inside the given [block]
         */
        public fun deploymentConfiguration(block: aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.deploymentConfiguration = aws.sdk.kotlin.services.ecs.model.DeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration] inside the given [block]
         */
        public fun serviceConnectConfiguration(block: aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration.Builder.() -> kotlin.Unit) {
            this.serviceConnectConfiguration = aws.sdk.kotlin.services.ecs.model.ServiceConnectConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
