// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A list of namespaced kernel parameters to set in the container. This parameter maps to `Sysctls` in the [Create a container](https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate) section of the [Docker Remote API](https://docs.docker.com/engine/api/v1.35/) and the `--sysctl` option to [docker run](https://docs.docker.com/engine/reference/run/#security-configuration). For example, you can configure `net.ipv4.tcp_keepalive_time` setting to maintain longer lived connections.
 *
 * We don't recommend that you specify network-related `systemControls` parameters for multiple containers in a single task that also uses either the `awsvpc` or `host` network mode. Doing this has the following disadvantages:
 * + For tasks that use the `awsvpc` network mode including Fargate, if you set `systemControls` for any container, it applies to all containers in the task. If you set different `systemControls` for multiple containers in a single task, the container that's started last determines which `systemControls` take effect.
 * + For tasks that use the `host` network mode, the network namespace `systemControls` aren't supported.
 *
 * If you're setting an IPC resource namespace to use for the containers in the task, the following conditions apply to your system controls. For more information, see [IPC mode](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_definition_ipcmode).
 * + For tasks that use the `host` IPC mode, IPC namespace `systemControls` aren't supported.
 * + For tasks that use the `task` IPC mode, IPC namespace `systemControls` values apply to all containers within a task.
 *
 * This parameter is not supported for Windows containers.
 *
 * This parameter is only supported for tasks that are hosted on Fargate if the tasks are using platform version `1.4.0` or later (Linux). This isn't supported for Windows containers on Fargate.
 */
public class SystemControl private constructor(builder: Builder) {
    /**
     * The namespaced kernel parameter to set a `value` for.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * The namespaced kernel parameter to set a `value` for.
     *
     * Valid IPC namespace values: `"kernel.msgmax" | "kernel.msgmnb" | "kernel.msgmni" | "kernel.sem" | "kernel.shmall" | "kernel.shmmax" | "kernel.shmmni" | "kernel.shm_rmid_forced"`, and `Sysctls` that start with `"fs.mqueue.*"`
     *
     * Valid network namespace values: `Sysctls` that start with `"net.*"`
     *
     * All of these values are supported by Fargate.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.SystemControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SystemControl(")
        append("namespace=$namespace,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = namespace?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SystemControl

        if (namespace != other.namespace) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.SystemControl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The namespaced kernel parameter to set a `value` for.
         */
        public var namespace: kotlin.String? = null
        /**
         * The namespaced kernel parameter to set a `value` for.
         *
         * Valid IPC namespace values: `"kernel.msgmax" | "kernel.msgmnb" | "kernel.msgmni" | "kernel.sem" | "kernel.shmall" | "kernel.shmmax" | "kernel.shmmni" | "kernel.shm_rmid_forced"`, and `Sysctls` that start with `"fs.mqueue.*"`
         *
         * Valid network namespace values: `Sysctls` that start with `"net.*"`
         *
         * All of these values are supported by Fargate.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.SystemControl) : this() {
            this.namespace = x.namespace
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.SystemControl = SystemControl(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
