// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details for the execute command session.
 */
public class Session private constructor(builder: Builder) {
    /**
     * The ID of the execute command session.
     */
    public val sessionId: kotlin.String? = builder.sessionId
    /**
     * A URL to the managed agent on the container that the SSM Session Manager client uses to send commands and receive output from the container.
     */
    public val streamUrl: kotlin.String? = builder.streamUrl
    /**
     * An encrypted token value containing session and caller information. It's used to authenticate the connection to the container.
     */
    public val tokenValue: kotlin.String? = builder.tokenValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Session = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Session(")
        append("sessionId=$sessionId,")
        append("streamUrl=$streamUrl,")
        append("tokenValue=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sessionId?.hashCode() ?: 0
        result = 31 * result + (streamUrl?.hashCode() ?: 0)
        result = 31 * result + (tokenValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Session

        if (sessionId != other.sessionId) return false
        if (streamUrl != other.streamUrl) return false
        if (tokenValue != other.tokenValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Session = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the execute command session.
         */
        public var sessionId: kotlin.String? = null
        /**
         * A URL to the managed agent on the container that the SSM Session Manager client uses to send commands and receive output from the container.
         */
        public var streamUrl: kotlin.String? = null
        /**
         * An encrypted token value containing session and caller information. It's used to authenticate the connection to the container.
         */
        public var tokenValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Session) : this() {
            this.sessionId = x.sessionId
            this.streamUrl = x.streamUrl
            this.tokenValue = x.tokenValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Session = Session(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
