// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details on the network bindings between a container and its host container instance. After a task reaches the `RUNNING` status, manual and automatic host and container port assignments are visible in the `networkBindings` section of DescribeTasks API responses.
 */
public class NetworkBinding private constructor(builder: Builder) {
    /**
     * The IP address that the container is bound to on the container instance.
     */
    public val bindIp: kotlin.String? = builder.bindIp
    /**
     * The port number on the container that's used with the network binding.
     */
    public val containerPort: kotlin.Int? = builder.containerPort
    /**
     * The port number range on the container that's bound to the dynamically mapped host port range.
     *
     * The following rules apply when you specify a `containerPortRange`:
     * + You must use either the `bridge` network mode or the `awsvpc` network mode.
     * + This parameter is available for both the EC2 and Fargate launch types.
     * + This parameter is available for both the Linux and Windows operating systems.
     * + The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the `ecs-init` package
     * + You can specify a maximum of 100 port ranges per container.
     * + You do not specify a `hostPortRange`. The value of the `hostPortRange` is set as follows:
     *    + For containers in a task with the `awsvpc` network mode, the `hostPortRange` is set to the same value as the `containerPortRange`. This is a static mapping strategy.
     *    + For containers in a task with the `bridge` network mode, the Amazon ECS agent finds open host ports from the default ephemeral range and passes it to docker to bind them to the container ports.
     * + The `containerPortRange` valid values are between 1 and 65535.
     * + A port can only be included in one port mapping per container.
     * + You cannot specify overlapping port ranges.
     * + The first port in the range must be less than last port in the range.
     * + Docker recommends that you turn off the docker-proxy in the Docker daemon config file when you have a large number of ports.For more information, see [ Issue #11185](https://github.com/moby/moby/issues/11185) on the Github website.For information about how to turn off the docker-proxy in the Docker daemon config file, see [Docker daemon](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#bootstrap_docker_daemon) in the *Amazon ECS Developer Guide*.
     *
     * You can call `DescribeTasks`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) to view the `hostPortRange` which are the host ports that are bound to the container ports.
     */
    public val containerPortRange: kotlin.String? = builder.containerPortRange
    /**
     * The port number on the host that's used with the network binding.
     */
    public val hostPort: kotlin.Int? = builder.hostPort
    /**
     * The port number range on the host that's used with the network binding. This is assigned is assigned by Docker and delivered by the Amazon ECS agent.
     */
    public val hostPortRange: kotlin.String? = builder.hostPortRange
    /**
     * The protocol used for the network binding.
     */
    public val protocol: aws.sdk.kotlin.services.ecs.model.TransportProtocol? = builder.protocol

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.NetworkBinding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkBinding(")
        append("bindIp=$bindIp,")
        append("containerPort=$containerPort,")
        append("containerPortRange=$containerPortRange,")
        append("hostPort=$hostPort,")
        append("hostPortRange=$hostPortRange,")
        append("protocol=$protocol")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bindIp?.hashCode() ?: 0
        result = 31 * result + (containerPort ?: 0)
        result = 31 * result + (containerPortRange?.hashCode() ?: 0)
        result = 31 * result + (hostPort ?: 0)
        result = 31 * result + (hostPortRange?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkBinding

        if (bindIp != other.bindIp) return false
        if (containerPort != other.containerPort) return false
        if (containerPortRange != other.containerPortRange) return false
        if (hostPort != other.hostPort) return false
        if (hostPortRange != other.hostPortRange) return false
        if (protocol != other.protocol) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.NetworkBinding = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The IP address that the container is bound to on the container instance.
         */
        public var bindIp: kotlin.String? = null
        /**
         * The port number on the container that's used with the network binding.
         */
        public var containerPort: kotlin.Int? = null
        /**
         * The port number range on the container that's bound to the dynamically mapped host port range.
         *
         * The following rules apply when you specify a `containerPortRange`:
         * + You must use either the `bridge` network mode or the `awsvpc` network mode.
         * + This parameter is available for both the EC2 and Fargate launch types.
         * + This parameter is available for both the Linux and Windows operating systems.
         * + The container instance must have at least version 1.67.0 of the container agent and at least version 1.67.0-1 of the `ecs-init` package
         * + You can specify a maximum of 100 port ranges per container.
         * + You do not specify a `hostPortRange`. The value of the `hostPortRange` is set as follows:
         *    + For containers in a task with the `awsvpc` network mode, the `hostPortRange` is set to the same value as the `containerPortRange`. This is a static mapping strategy.
         *    + For containers in a task with the `bridge` network mode, the Amazon ECS agent finds open host ports from the default ephemeral range and passes it to docker to bind them to the container ports.
         * + The `containerPortRange` valid values are between 1 and 65535.
         * + A port can only be included in one port mapping per container.
         * + You cannot specify overlapping port ranges.
         * + The first port in the range must be less than last port in the range.
         * + Docker recommends that you turn off the docker-proxy in the Docker daemon config file when you have a large number of ports.For more information, see [ Issue #11185](https://github.com/moby/moby/issues/11185) on the Github website.For information about how to turn off the docker-proxy in the Docker daemon config file, see [Docker daemon](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/bootstrap_container_instance.html#bootstrap_docker_daemon) in the *Amazon ECS Developer Guide*.
         *
         * You can call `DescribeTasks`[](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DescribeTasks.html) to view the `hostPortRange` which are the host ports that are bound to the container ports.
         */
        public var containerPortRange: kotlin.String? = null
        /**
         * The port number on the host that's used with the network binding.
         */
        public var hostPort: kotlin.Int? = null
        /**
         * The port number range on the host that's used with the network binding. This is assigned is assigned by Docker and delivered by the Amazon ECS agent.
         */
        public var hostPortRange: kotlin.String? = null
        /**
         * The protocol used for the network binding.
         */
        public var protocol: aws.sdk.kotlin.services.ecs.model.TransportProtocol? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.NetworkBinding) : this() {
            this.bindIp = x.bindIp
            this.containerPort = x.containerPort
            this.containerPortRange = x.containerPortRange
            this.hostPort = x.hostPort
            this.hostPortRange = x.hostPortRange
            this.protocol = x.protocol
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.NetworkBinding = NetworkBinding(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
