// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListContainerInstancesRequest private constructor(builder: Builder) {
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * You can filter the results of a `ListContainerInstances` operation with cluster query language statements. For more information, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val filter: kotlin.String? = builder.filter
    /**
     * The maximum number of container instance results that `ListContainerInstances` returned in paginated output. When this parameter is used, `ListContainerInstances` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListContainerInstances` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListContainerInstances` returns up to 100 results and a `nextToken` value if applicable.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a `ListContainerInstances` request indicating that more results are available to fulfill the request and further calls are needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
     *
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Filters the container instances by status. For example, if you specify the `DRAINING` status, the results include only container instances that have been set to `DRAINING` using UpdateContainerInstancesState. If you don't specify this parameter, the default is to include container instances set to all states other than `INACTIVE`.
     */
    public val status: aws.sdk.kotlin.services.ecs.model.ContainerInstanceStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ListContainerInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListContainerInstancesRequest(")
        append("cluster=$cluster,")
        append("filter=$filter,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cluster?.hashCode() ?: 0
        result = 31 * result + (filter?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListContainerInstancesRequest

        if (cluster != other.cluster) return false
        if (filter != other.filter) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ListContainerInstancesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the container instances to list. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * You can filter the results of a `ListContainerInstances` operation with cluster query language statements. For more information, see [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var filter: kotlin.String? = null
        /**
         * The maximum number of container instance results that `ListContainerInstances` returned in paginated output. When this parameter is used, `ListContainerInstances` only returns `maxResults` results in a single page along with a `nextToken` response element. The remaining results of the initial request can be seen by sending another `ListContainerInstances` request with the returned `nextToken` value. This value can be between 1 and 100. If this parameter isn't used, then `ListContainerInstances` returns up to 100 results and a `nextToken` value if applicable.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a `ListContainerInstances` request indicating that more results are available to fulfill the request and further calls are needed. If `maxResults` was provided, it's possible the number of results to be fewer than `maxResults`.
         *
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Filters the container instances by status. For example, if you specify the `DRAINING` status, the results include only container instances that have been set to `DRAINING` using UpdateContainerInstancesState. If you don't specify this parameter, the default is to include container instances set to all states other than `INACTIVE`.
         */
        public var status: aws.sdk.kotlin.services.ecs.model.ContainerInstanceStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ListContainerInstancesRequest) : this() {
            this.cluster = x.cluster
            this.filter = x.filter
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ListContainerInstancesRequest = ListContainerInstancesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
