// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object representing a container instance host device.
 */
public class Device private constructor(builder: Builder) {
    /**
     * The path inside the container at which to expose the host device.
     */
    public val containerPath: kotlin.String? = builder.containerPath
    /**
     * The path for the device on the host container instance.
     */
    public val hostPath: kotlin.String = requireNotNull(builder.hostPath) { "A non-null value must be provided for hostPath" }
    /**
     * The explicit permissions to provide to the container for the device. By default, the container has permissions for `read`, `write`, and `mknod` for the device.
     */
    public val permissions: List<DeviceCgroupPermission>? = builder.permissions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Device = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Device(")
        append("containerPath=$containerPath,")
        append("hostPath=$hostPath,")
        append("permissions=$permissions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = containerPath?.hashCode() ?: 0
        result = 31 * result + (hostPath.hashCode())
        result = 31 * result + (permissions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Device

        if (containerPath != other.containerPath) return false
        if (hostPath != other.hostPath) return false
        if (permissions != other.permissions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Device = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The path inside the container at which to expose the host device.
         */
        public var containerPath: kotlin.String? = null
        /**
         * The path for the device on the host container instance.
         */
        public var hostPath: kotlin.String? = null
        /**
         * The explicit permissions to provide to the container for the device. By default, the container has permissions for `read`, `write`, and `mknod` for the device.
         */
        public var permissions: List<DeviceCgroupPermission>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Device) : this() {
            this.containerPath = x.containerPath
            this.hostPath = x.hostPath
            this.permissions = x.permissions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Device = Device(this)

        internal fun correctErrors(): Builder {
            if (hostPath == null) hostPath = ""
            return this
        }
    }
}
