// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateTaskSetRequest private constructor(builder: Builder) {
    /**
     * The capacity provider strategy to use for the task set.
     *
     * A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
     *
     * If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or `launchType` is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
     *
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
     *
     * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     *
     * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
     */
    public val capacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.capacityProviderStrategy
    /**
     * An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 36 ASCII characters in the range of 33-126 (inclusive) are allowed.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the `ECS_TASK_SET_EXTERNAL_ID` Cloud Map attribute set to the provided value.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The launch type that new tasks in the task set uses. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
     *
     * If a `launchType` is specified, the `capacityProviderStrategy` parameter must be omitted.
     */
    public val launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = builder.launchType
    /**
     * A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.
     */
    public val loadBalancers: List<LoadBalancer>? = builder.loadBalancers
    /**
     * An object representing the network configuration for a task set.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * The platform version that the tasks in the task set uses. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the `LATEST` platform version is used.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * A floating-point percentage of the desired number of tasks to place and keep running in the task set.
     */
    public val scale: aws.sdk.kotlin.services.ecs.model.Scale? = builder.scale
    /**
     * The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
     */
    public val service: kotlin.String? = builder.service
    /**
     * The details of the service discovery registries to assign to this task set. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
     */
    public val serviceRegistries: List<ServiceRegistry>? = builder.serviceRegistries
    /**
     * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both. When a service is deleted, the tags are deleted.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The task definition for the tasks in the task set to use. If a revision isn't specified, the latest `ACTIVE` revision is used.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.CreateTaskSetRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTaskSetRequest(")
        append("capacityProviderStrategy=$capacityProviderStrategy,")
        append("clientToken=$clientToken,")
        append("cluster=$cluster,")
        append("externalId=$externalId,")
        append("launchType=$launchType,")
        append("loadBalancers=$loadBalancers,")
        append("networkConfiguration=$networkConfiguration,")
        append("platformVersion=$platformVersion,")
        append("scale=$scale,")
        append("service=$service,")
        append("serviceRegistries=$serviceRegistries,")
        append("tags=$tags,")
        append("taskDefinition=$taskDefinition")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityProviderStrategy?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (cluster?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (launchType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancers?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (scale?.hashCode() ?: 0)
        result = 31 * result + (service?.hashCode() ?: 0)
        result = 31 * result + (serviceRegistries?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTaskSetRequest

        if (capacityProviderStrategy != other.capacityProviderStrategy) return false
        if (clientToken != other.clientToken) return false
        if (cluster != other.cluster) return false
        if (externalId != other.externalId) return false
        if (launchType != other.launchType) return false
        if (loadBalancers != other.loadBalancers) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (platformVersion != other.platformVersion) return false
        if (scale != other.scale) return false
        if (service != other.service) return false
        if (serviceRegistries != other.serviceRegistries) return false
        if (tags != other.tags) return false
        if (taskDefinition != other.taskDefinition) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.CreateTaskSetRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The capacity provider strategy to use for the task set.
         *
         * A capacity provider strategy consists of one or more capacity providers along with the `base` and `weight` to assign to them. A capacity provider must be associated with the cluster to be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster. Only capacity providers with an `ACTIVE` or `UPDATING` status can be used.
         *
         * If a `capacityProviderStrategy` is specified, the `launchType` parameter must be omitted. If no `capacityProviderStrategy` or `launchType` is specified, the `defaultCapacityProviderStrategy` for the cluster is used.
         *
         * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New capacity providers can be created with the CreateCapacityProvider API operation.
         *
         * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         *
         * The PutClusterCapacityProviders API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
         */
        public var capacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * An identifier that you provide to ensure the idempotency of the request. It must be unique and is case sensitive. Up to 36 ASCII characters in the range of 33-126 (inclusive) are allowed.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that hosts the service to create the task set in.
         */
        public var cluster: kotlin.String? = null
        /**
         * An optional non-unique tag that identifies this task set in external systems. If the task set is associated with a service discovery registry, the tasks in this task set will have the `ECS_TASK_SET_EXTERNAL_ID` Cloud Map attribute set to the provided value.
         */
        public var externalId: kotlin.String? = null
        /**
         * The launch type that new tasks in the task set uses. For more information, see [Amazon ECS launch types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html) in the *Amazon Elastic Container Service Developer Guide*.
         *
         * If a `launchType` is specified, the `capacityProviderStrategy` parameter must be omitted.
         */
        public var launchType: aws.sdk.kotlin.services.ecs.model.LaunchType? = null
        /**
         * A load balancer object representing the load balancer to use with the task set. The supported load balancer types are either an Application Load Balancer or a Network Load Balancer.
         */
        public var loadBalancers: List<LoadBalancer>? = null
        /**
         * An object representing the network configuration for a task set.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * The platform version that the tasks in the task set uses. A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the `LATEST` platform version is used.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * A floating-point percentage of the desired number of tasks to place and keep running in the task set.
         */
        public var scale: aws.sdk.kotlin.services.ecs.model.Scale? = null
        /**
         * The short name or full Amazon Resource Name (ARN) of the service to create the task set in.
         */
        public var service: kotlin.String? = null
        /**
         * The details of the service discovery registries to assign to this task set. For more information, see [Service discovery](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html).
         */
        public var serviceRegistries: List<ServiceRegistry>? = null
        /**
         * The metadata that you apply to the task set to help you categorize and organize them. Each tag consists of a key and an optional value. You define both. When a service is deleted, the tags are deleted.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The task definition for the tasks in the task set to use. If a revision isn't specified, the latest `ACTIVE` revision is used.
         */
        public var taskDefinition: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.CreateTaskSetRequest) : this() {
            this.capacityProviderStrategy = x.capacityProviderStrategy
            this.clientToken = x.clientToken
            this.cluster = x.cluster
            this.externalId = x.externalId
            this.launchType = x.launchType
            this.loadBalancers = x.loadBalancers
            this.networkConfiguration = x.networkConfiguration
            this.platformVersion = x.platformVersion
            this.scale = x.scale
            this.service = x.service
            this.serviceRegistries = x.serviceRegistries
            this.tags = x.tags
            this.taskDefinition = x.taskDefinition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.CreateTaskSetRequest = CreateTaskSetRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.Scale] inside the given [block]
         */
        public fun scale(block: aws.sdk.kotlin.services.ecs.model.Scale.Builder.() -> kotlin.Unit) {
            this.scale = aws.sdk.kotlin.services.ecs.model.Scale.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
