// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon EC2 or External instance that's running the Amazon ECS agent and has been registered with a cluster.
 */
public class ContainerInstance private constructor(builder: Builder) {
    /**
     * This parameter returns `true` if the agent is connected to Amazon ECS. An instance with an agent that may be unhealthy or stopped return `false`. Only instances connected to an agent can accept task placement requests.
     */
    public val agentConnected: kotlin.Boolean = builder.agentConnected
    /**
     * The status of the most recent agent update. If an update wasn't ever requested, this value is `NULL`.
     */
    public val agentUpdateStatus: aws.sdk.kotlin.services.ecs.model.AgentUpdateStatus? = builder.agentUpdateStatus
    /**
     * The resources attached to a container instance, such as an elastic network interface.
     */
    public val attachments: List<Attachment>? = builder.attachments
    /**
     * The attributes set for the container instance, either by the Amazon ECS container agent at instance registration or manually with the PutAttributes operation.
     */
    public val attributes: List<Attribute>? = builder.attributes
    /**
     * The capacity provider that's associated with the container instance.
     */
    public val capacityProviderName: kotlin.String? = builder.capacityProviderName
    /**
     * The Amazon Resource Name (ARN) of the container instance. For more information about the ARN format, see [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids) in the *Amazon ECS Developer Guide*.
     */
    public val containerInstanceArn: kotlin.String? = builder.containerInstanceArn
    /**
     * The ID of the container instance. For Amazon EC2 instances, this value is the Amazon EC2 instance ID. For external instances, this value is the Amazon Web Services Systems Manager managed instance ID.
     */
    public val ec2InstanceId: kotlin.String? = builder.ec2InstanceId
    /**
     * An object representing the health status of the container instance.
     */
    public val healthStatus: aws.sdk.kotlin.services.ecs.model.ContainerInstanceHealthStatus? = builder.healthStatus
    /**
     * The number of tasks on the container instance that are in the `PENDING` status.
     */
    public val pendingTasksCount: kotlin.Int = builder.pendingTasksCount
    /**
     * The Unix timestamp for the time when the container instance was registered.
     */
    public val registeredAt: aws.smithy.kotlin.runtime.time.Instant? = builder.registeredAt
    /**
     * For CPU and memory resource types, this parameter describes the amount of each resource that was available on the container instance when the container agent registered it with Amazon ECS. This value represents the total amount of CPU and memory that can be allocated on this container instance to tasks. For port resource types, this parameter describes the ports that were reserved by the Amazon ECS container agent when it registered the container instance with Amazon ECS.
     */
    public val registeredResources: List<Resource>? = builder.registeredResources
    /**
     * For CPU and memory resource types, this parameter describes the remaining CPU and memory that wasn't already allocated to tasks and is therefore available for new tasks. For port resource types, this parameter describes the ports that were reserved by the Amazon ECS container agent (at instance registration time) and any task containers that have reserved port mappings on the host (with the `host` or `bridge` network mode). Any port that's not specified here is available for new tasks.
     */
    public val remainingResources: List<Resource>? = builder.remainingResources
    /**
     * The number of tasks on the container instance that have a desired status (`desiredStatus`) of `RUNNING`.
     */
    public val runningTasksCount: kotlin.Int = builder.runningTasksCount
    /**
     * The status of the container instance. The valid values are `REGISTERING`, `REGISTRATION_FAILED`, `ACTIVE`, `INACTIVE`, `DEREGISTERING`, or `DRAINING`.
     *
     * If your account has opted in to the `awsvpcTrunking` account setting, then any newly registered container instance will transition to a `REGISTERING` status while the trunk elastic network interface is provisioned for the instance. If the registration fails, the instance will transition to a `REGISTRATION_FAILED` status. You can describe the container instance and see the reason for failure in the `statusReason` parameter. Once the container instance is terminated, the instance transitions to a `DEREGISTERING` status while the trunk elastic network interface is deprovisioned. The instance then transitions to an `INACTIVE` status.
     *
     * The `ACTIVE` status indicates that the container instance can accept tasks. The `DRAINING` indicates that new tasks aren't placed on the container instance and any service tasks running on the container instance are removed if possible. For more information, see [Container instance draining](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-draining.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The reason that the container instance reached its current status.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The version counter for the container instance. Every time a container instance experiences a change that triggers a CloudWatch event, the version counter is incremented. If you're replicating your Amazon ECS container instance state with CloudWatch Events, you can compare the version of a container instance reported by the Amazon ECS APIs with the version reported in CloudWatch Events for the container instance (inside the `detail` object) to verify that the version in your event stream is current.
     */
    public val version: kotlin.Long = builder.version
    /**
     * The version information for the Amazon ECS container agent and Docker daemon running on the container instance.
     */
    public val versionInfo: aws.sdk.kotlin.services.ecs.model.VersionInfo? = builder.versionInfo

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.ContainerInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ContainerInstance(")
        append("agentConnected=$agentConnected,")
        append("agentUpdateStatus=$agentUpdateStatus,")
        append("attachments=$attachments,")
        append("attributes=$attributes,")
        append("capacityProviderName=$capacityProviderName,")
        append("containerInstanceArn=$containerInstanceArn,")
        append("ec2InstanceId=$ec2InstanceId,")
        append("healthStatus=$healthStatus,")
        append("pendingTasksCount=$pendingTasksCount,")
        append("registeredAt=$registeredAt,")
        append("registeredResources=$registeredResources,")
        append("remainingResources=$remainingResources,")
        append("runningTasksCount=$runningTasksCount,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("tags=$tags,")
        append("version=$version,")
        append("versionInfo=$versionInfo")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentConnected.hashCode()
        result = 31 * result + (agentUpdateStatus?.hashCode() ?: 0)
        result = 31 * result + (attachments?.hashCode() ?: 0)
        result = 31 * result + (attributes?.hashCode() ?: 0)
        result = 31 * result + (capacityProviderName?.hashCode() ?: 0)
        result = 31 * result + (containerInstanceArn?.hashCode() ?: 0)
        result = 31 * result + (ec2InstanceId?.hashCode() ?: 0)
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (pendingTasksCount)
        result = 31 * result + (registeredAt?.hashCode() ?: 0)
        result = 31 * result + (registeredResources?.hashCode() ?: 0)
        result = 31 * result + (remainingResources?.hashCode() ?: 0)
        result = 31 * result + (runningTasksCount)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version.hashCode())
        result = 31 * result + (versionInfo?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ContainerInstance

        if (agentConnected != other.agentConnected) return false
        if (agentUpdateStatus != other.agentUpdateStatus) return false
        if (attachments != other.attachments) return false
        if (attributes != other.attributes) return false
        if (capacityProviderName != other.capacityProviderName) return false
        if (containerInstanceArn != other.containerInstanceArn) return false
        if (ec2InstanceId != other.ec2InstanceId) return false
        if (healthStatus != other.healthStatus) return false
        if (pendingTasksCount != other.pendingTasksCount) return false
        if (registeredAt != other.registeredAt) return false
        if (registeredResources != other.registeredResources) return false
        if (remainingResources != other.remainingResources) return false
        if (runningTasksCount != other.runningTasksCount) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (tags != other.tags) return false
        if (version != other.version) return false
        if (versionInfo != other.versionInfo) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.ContainerInstance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * This parameter returns `true` if the agent is connected to Amazon ECS. An instance with an agent that may be unhealthy or stopped return `false`. Only instances connected to an agent can accept task placement requests.
         */
        public var agentConnected: kotlin.Boolean = false
        /**
         * The status of the most recent agent update. If an update wasn't ever requested, this value is `NULL`.
         */
        public var agentUpdateStatus: aws.sdk.kotlin.services.ecs.model.AgentUpdateStatus? = null
        /**
         * The resources attached to a container instance, such as an elastic network interface.
         */
        public var attachments: List<Attachment>? = null
        /**
         * The attributes set for the container instance, either by the Amazon ECS container agent at instance registration or manually with the PutAttributes operation.
         */
        public var attributes: List<Attribute>? = null
        /**
         * The capacity provider that's associated with the container instance.
         */
        public var capacityProviderName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the container instance. For more information about the ARN format, see [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids) in the *Amazon ECS Developer Guide*.
         */
        public var containerInstanceArn: kotlin.String? = null
        /**
         * The ID of the container instance. For Amazon EC2 instances, this value is the Amazon EC2 instance ID. For external instances, this value is the Amazon Web Services Systems Manager managed instance ID.
         */
        public var ec2InstanceId: kotlin.String? = null
        /**
         * An object representing the health status of the container instance.
         */
        public var healthStatus: aws.sdk.kotlin.services.ecs.model.ContainerInstanceHealthStatus? = null
        /**
         * The number of tasks on the container instance that are in the `PENDING` status.
         */
        public var pendingTasksCount: kotlin.Int = 0
        /**
         * The Unix timestamp for the time when the container instance was registered.
         */
        public var registeredAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * For CPU and memory resource types, this parameter describes the amount of each resource that was available on the container instance when the container agent registered it with Amazon ECS. This value represents the total amount of CPU and memory that can be allocated on this container instance to tasks. For port resource types, this parameter describes the ports that were reserved by the Amazon ECS container agent when it registered the container instance with Amazon ECS.
         */
        public var registeredResources: List<Resource>? = null
        /**
         * For CPU and memory resource types, this parameter describes the remaining CPU and memory that wasn't already allocated to tasks and is therefore available for new tasks. For port resource types, this parameter describes the ports that were reserved by the Amazon ECS container agent (at instance registration time) and any task containers that have reserved port mappings on the host (with the `host` or `bridge` network mode). Any port that's not specified here is available for new tasks.
         */
        public var remainingResources: List<Resource>? = null
        /**
         * The number of tasks on the container instance that have a desired status (`desiredStatus`) of `RUNNING`.
         */
        public var runningTasksCount: kotlin.Int = 0
        /**
         * The status of the container instance. The valid values are `REGISTERING`, `REGISTRATION_FAILED`, `ACTIVE`, `INACTIVE`, `DEREGISTERING`, or `DRAINING`.
         *
         * If your account has opted in to the `awsvpcTrunking` account setting, then any newly registered container instance will transition to a `REGISTERING` status while the trunk elastic network interface is provisioned for the instance. If the registration fails, the instance will transition to a `REGISTRATION_FAILED` status. You can describe the container instance and see the reason for failure in the `statusReason` parameter. Once the container instance is terminated, the instance transitions to a `DEREGISTERING` status while the trunk elastic network interface is deprovisioned. The instance then transitions to an `INACTIVE` status.
         *
         * The `ACTIVE` status indicates that the container instance can accept tasks. The `DRAINING` indicates that new tasks aren't placed on the container instance and any service tasks running on the container instance are removed if possible. For more information, see [Container instance draining](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/container-instance-draining.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var status: kotlin.String? = null
        /**
         * The reason that the container instance reached its current status.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The metadata that you apply to the container instance to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The version counter for the container instance. Every time a container instance experiences a change that triggers a CloudWatch event, the version counter is incremented. If you're replicating your Amazon ECS container instance state with CloudWatch Events, you can compare the version of a container instance reported by the Amazon ECS APIs with the version reported in CloudWatch Events for the container instance (inside the `detail` object) to verify that the version in your event stream is current.
         */
        public var version: kotlin.Long = 0L
        /**
         * The version information for the Amazon ECS container agent and Docker daemon running on the container instance.
         */
        public var versionInfo: aws.sdk.kotlin.services.ecs.model.VersionInfo? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.ContainerInstance) : this() {
            this.agentConnected = x.agentConnected
            this.agentUpdateStatus = x.agentUpdateStatus
            this.attachments = x.attachments
            this.attributes = x.attributes
            this.capacityProviderName = x.capacityProviderName
            this.containerInstanceArn = x.containerInstanceArn
            this.ec2InstanceId = x.ec2InstanceId
            this.healthStatus = x.healthStatus
            this.pendingTasksCount = x.pendingTasksCount
            this.registeredAt = x.registeredAt
            this.registeredResources = x.registeredResources
            this.remainingResources = x.remainingResources
            this.runningTasksCount = x.runningTasksCount
            this.status = x.status
            this.statusReason = x.statusReason
            this.tags = x.tags
            this.version = x.version
            this.versionInfo = x.versionInfo
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.ContainerInstance = ContainerInstance(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ContainerInstanceHealthStatus] inside the given [block]
         */
        public fun healthStatus(block: aws.sdk.kotlin.services.ecs.model.ContainerInstanceHealthStatus.Builder.() -> kotlin.Unit) {
            this.healthStatus = aws.sdk.kotlin.services.ecs.model.ContainerInstanceHealthStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.VersionInfo] inside the given [block]
         */
        public fun versionInfo(block: aws.sdk.kotlin.services.ecs.model.VersionInfo.Builder.() -> kotlin.Unit) {
            this.versionInfo = aws.sdk.kotlin.services.ecs.model.VersionInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
