// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A regional grouping of one or more container instances where you can run task requests. Each account receives a default cluster the first time you use the Amazon ECS service, but you may also create other clusters. Clusters may contain more than one instance type simultaneously.
 */
public class Cluster private constructor(builder: Builder) {
    /**
     * The number of services that are running on the cluster in an `ACTIVE` state. You can view these services with ListServices.
     */
    public val activeServicesCount: kotlin.Int = builder.activeServicesCount
    /**
     * The resources attached to a cluster. When using a capacity provider with a cluster, the capacity provider and associated resources are returned as cluster attachments.
     */
    public val attachments: List<Attachment>? = builder.attachments
    /**
     * The status of the capacity providers associated with the cluster. The following are the states that are returned.
     *
     * ## UPDATE_IN_PROGRESS
     * The available capacity providers for the cluster are updating.
     *
     * ## UPDATE_COMPLETE
     * The capacity providers have successfully updated.
     *
     * ## UPDATE_FAILED
     * The capacity provider updates failed.
     */
    public val attachmentsStatus: kotlin.String? = builder.attachmentsStatus
    /**
     * The capacity providers associated with the cluster.
     */
    public val capacityProviders: List<String>? = builder.capacityProviders
    /**
     * The Amazon Resource Name (ARN) that identifies the cluster. For more information about the ARN format, see [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids) in the *Amazon ECS Developer Guide*.
     */
    public val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * A user-generated string that you use to identify your cluster.
     */
    public val clusterName: kotlin.String? = builder.clusterName
    /**
     * The execute command configuration for the cluster.
     */
    public val configuration: aws.sdk.kotlin.services.ecs.model.ClusterConfiguration? = builder.configuration
    /**
     * The default capacity provider strategy for the cluster. When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
     */
    public val defaultCapacityProviderStrategy: List<CapacityProviderStrategyItem>? = builder.defaultCapacityProviderStrategy
    /**
     * The number of tasks in the cluster that are in the `PENDING` state.
     */
    public val pendingTasksCount: kotlin.Int = builder.pendingTasksCount
    /**
     * The number of container instances registered into the cluster. This includes container instances in both `ACTIVE` and `DRAINING` status.
     */
    public val registeredContainerInstancesCount: kotlin.Int = builder.registeredContainerInstancesCount
    /**
     * The number of tasks in the cluster that are in the `RUNNING` state.
     */
    public val runningTasksCount: kotlin.Int = builder.runningTasksCount
    /**
     * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the `enabled` parameter to `true` in the `ServiceConnectConfiguration`. You can set the namespace of each service individually in the `ServiceConnectConfiguration` to override this default parameter.
     *
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val serviceConnectDefaults: aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults? = builder.serviceConnectDefaults
    /**
     * The settings for the cluster. This parameter indicates whether CloudWatch Container Insights is on or off for a cluster.
     */
    public val settings: List<ClusterSetting>? = builder.settings
    /**
     * Additional information about your clusters that are separated by launch type. They include the following:
     * + runningEC2TasksCount
     * + RunningFargateTasksCount
     * + pendingEC2TasksCount
     * + pendingFargateTasksCount
     * + activeEC2ServiceCount
     * + activeFargateServiceCount
     * + drainingEC2ServiceCount
     * + drainingFargateServiceCount
     */
    public val statistics: List<KeyValuePair>? = builder.statistics
    /**
     * The status of the cluster. The following are the possible states that are returned.
     *
     * ## ACTIVE
     * The cluster is ready to accept tasks and if applicable you can register container instances with the cluster.
     *
     * ## PROVISIONING
     * The cluster has capacity providers that are associated with it and the resources needed for the capacity provider are being created.
     *
     * ## DEPROVISIONING
     * The cluster has capacity providers that are associated with it and the resources needed for the capacity provider are being deleted.
     *
     * ## FAILED
     * The cluster has capacity providers that are associated with it and the resources needed for the capacity provider have failed to create.
     *
     * ## INACTIVE
     * The cluster has been deleted. Clusters with an `INACTIVE` status may remain discoverable in your account for a period of time. However, this behavior is subject to change in the future. We don't recommend that you rely on `INACTIVE` clusters persisting.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("activeServicesCount=$activeServicesCount,")
        append("attachments=$attachments,")
        append("attachmentsStatus=$attachmentsStatus,")
        append("capacityProviders=$capacityProviders,")
        append("clusterArn=$clusterArn,")
        append("clusterName=$clusterName,")
        append("configuration=$configuration,")
        append("defaultCapacityProviderStrategy=$defaultCapacityProviderStrategy,")
        append("pendingTasksCount=$pendingTasksCount,")
        append("registeredContainerInstancesCount=$registeredContainerInstancesCount,")
        append("runningTasksCount=$runningTasksCount,")
        append("serviceConnectDefaults=$serviceConnectDefaults,")
        append("settings=$settings,")
        append("statistics=$statistics,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeServicesCount
        result = 31 * result + (attachments?.hashCode() ?: 0)
        result = 31 * result + (attachmentsStatus?.hashCode() ?: 0)
        result = 31 * result + (capacityProviders?.hashCode() ?: 0)
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (defaultCapacityProviderStrategy?.hashCode() ?: 0)
        result = 31 * result + (pendingTasksCount)
        result = 31 * result + (registeredContainerInstancesCount)
        result = 31 * result + (runningTasksCount)
        result = 31 * result + (serviceConnectDefaults?.hashCode() ?: 0)
        result = 31 * result + (settings?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (activeServicesCount != other.activeServicesCount) return false
        if (attachments != other.attachments) return false
        if (attachmentsStatus != other.attachmentsStatus) return false
        if (capacityProviders != other.capacityProviders) return false
        if (clusterArn != other.clusterArn) return false
        if (clusterName != other.clusterName) return false
        if (configuration != other.configuration) return false
        if (defaultCapacityProviderStrategy != other.defaultCapacityProviderStrategy) return false
        if (pendingTasksCount != other.pendingTasksCount) return false
        if (registeredContainerInstancesCount != other.registeredContainerInstancesCount) return false
        if (runningTasksCount != other.runningTasksCount) return false
        if (serviceConnectDefaults != other.serviceConnectDefaults) return false
        if (settings != other.settings) return false
        if (statistics != other.statistics) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.Cluster = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of services that are running on the cluster in an `ACTIVE` state. You can view these services with ListServices.
         */
        public var activeServicesCount: kotlin.Int = 0
        /**
         * The resources attached to a cluster. When using a capacity provider with a cluster, the capacity provider and associated resources are returned as cluster attachments.
         */
        public var attachments: List<Attachment>? = null
        /**
         * The status of the capacity providers associated with the cluster. The following are the states that are returned.
         *
         * ## UPDATE_IN_PROGRESS
         * The available capacity providers for the cluster are updating.
         *
         * ## UPDATE_COMPLETE
         * The capacity providers have successfully updated.
         *
         * ## UPDATE_FAILED
         * The capacity provider updates failed.
         */
        public var attachmentsStatus: kotlin.String? = null
        /**
         * The capacity providers associated with the cluster.
         */
        public var capacityProviders: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) that identifies the cluster. For more information about the ARN format, see [Amazon Resource Name (ARN)](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-account-settings.html#ecs-resource-ids) in the *Amazon ECS Developer Guide*.
         */
        public var clusterArn: kotlin.String? = null
        /**
         * A user-generated string that you use to identify your cluster.
         */
        public var clusterName: kotlin.String? = null
        /**
         * The execute command configuration for the cluster.
         */
        public var configuration: aws.sdk.kotlin.services.ecs.model.ClusterConfiguration? = null
        /**
         * The default capacity provider strategy for the cluster. When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
         */
        public var defaultCapacityProviderStrategy: List<CapacityProviderStrategyItem>? = null
        /**
         * The number of tasks in the cluster that are in the `PENDING` state.
         */
        public var pendingTasksCount: kotlin.Int = 0
        /**
         * The number of container instances registered into the cluster. This includes container instances in both `ACTIVE` and `DRAINING` status.
         */
        public var registeredContainerInstancesCount: kotlin.Int = 0
        /**
         * The number of tasks in the cluster that are in the `RUNNING` state.
         */
        public var runningTasksCount: kotlin.Int = 0
        /**
         * Use this parameter to set a default Service Connect namespace. After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the `enabled` parameter to `true` in the `ServiceConnectConfiguration`. You can set the namespace of each service individually in the `ServiceConnectConfiguration` to override this default parameter.
         *
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see [Service Connect](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var serviceConnectDefaults: aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults? = null
        /**
         * The settings for the cluster. This parameter indicates whether CloudWatch Container Insights is on or off for a cluster.
         */
        public var settings: List<ClusterSetting>? = null
        /**
         * Additional information about your clusters that are separated by launch type. They include the following:
         * + runningEC2TasksCount
         * + RunningFargateTasksCount
         * + pendingEC2TasksCount
         * + pendingFargateTasksCount
         * + activeEC2ServiceCount
         * + activeFargateServiceCount
         * + drainingEC2ServiceCount
         * + drainingFargateServiceCount
         */
        public var statistics: List<KeyValuePair>? = null
        /**
         * The status of the cluster. The following are the possible states that are returned.
         *
         * ## ACTIVE
         * The cluster is ready to accept tasks and if applicable you can register container instances with the cluster.
         *
         * ## PROVISIONING
         * The cluster has capacity providers that are associated with it and the resources needed for the capacity provider are being created.
         *
         * ## DEPROVISIONING
         * The cluster has capacity providers that are associated with it and the resources needed for the capacity provider are being deleted.
         *
         * ## FAILED
         * The cluster has capacity providers that are associated with it and the resources needed for the capacity provider have failed to create.
         *
         * ## INACTIVE
         * The cluster has been deleted. Clusters with an `INACTIVE` status may remain discoverable in your account for a period of time. However, this behavior is subject to change in the future. We don't recommend that you rely on `INACTIVE` clusters persisting.
         */
        public var status: kotlin.String? = null
        /**
         * The metadata that you apply to the cluster to help you categorize and organize them. Each tag consists of a key and an optional value. You define both.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.Cluster) : this() {
            this.activeServicesCount = x.activeServicesCount
            this.attachments = x.attachments
            this.attachmentsStatus = x.attachmentsStatus
            this.capacityProviders = x.capacityProviders
            this.clusterArn = x.clusterArn
            this.clusterName = x.clusterName
            this.configuration = x.configuration
            this.defaultCapacityProviderStrategy = x.defaultCapacityProviderStrategy
            this.pendingTasksCount = x.pendingTasksCount
            this.registeredContainerInstancesCount = x.registeredContainerInstancesCount
            this.runningTasksCount = x.runningTasksCount
            this.serviceConnectDefaults = x.serviceConnectDefaults
            this.settings = x.settings
            this.statistics = x.statistics
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ClusterConfiguration] inside the given [block]
         */
        public fun configuration(block: aws.sdk.kotlin.services.ecs.model.ClusterConfiguration.Builder.() -> kotlin.Unit) {
            this.configuration = aws.sdk.kotlin.services.ecs.model.ClusterConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults] inside the given [block]
         */
        public fun serviceConnectDefaults(block: aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults.Builder.() -> kotlin.Unit) {
            this.serviceConnectDefaults = aws.sdk.kotlin.services.ecs.model.ClusterServiceConnectDefaults.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
