// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The details of a capacity provider strategy. A capacity provider strategy can be set when using the RunTask or CreateCluster APIs or as the default capacity provider strategy for a cluster with the CreateCluster API.
 *
 * Only capacity providers that are already associated with a cluster and have an `ACTIVE` or `UPDATING` status can be used in a capacity provider strategy. The PutClusterCapacityProviders API is used to associate a capacity provider with a cluster.
 *
 * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New Auto Scaling group capacity providers can be created with the CreateCapacityProvider API operation.
 *
 * To use a Fargate capacity provider, specify either the `FARGATE` or `FARGATE_SPOT` capacity providers. The Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used in a capacity provider strategy.
 *
 * With `FARGATE_SPOT`, you can run interruption tolerant tasks at a rate that's discounted compared to the `FARGATE` price. `FARGATE_SPOT` runs tasks on spare compute capacity. When Amazon Web Services needs the capacity back, your tasks are interrupted with a two-minute warning. `FARGATE_SPOT` only supports Linux tasks with the X86_64 architecture on platform version 1.3.0 or later.
 *
 * A capacity provider strategy may contain a maximum of 6 capacity providers.
 */
public class CapacityProviderStrategyItem private constructor(builder: Builder) {
    /**
     * The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of `0` is used.
     */
    public val base: kotlin.Int = builder.base
    /**
     * The short name of the capacity provider.
     */
    public val capacityProvider: kotlin.String = requireNotNull(builder.capacityProvider) { "A non-null value must be provided for capacityProvider" }
    /**
     * The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` value, if defined, is satisfied.
     *
     * If no `weight` value is specified, the default value of `0` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of `0` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of `0`, any `RunTask` or `CreateService` actions using the capacity provider strategy will fail.
     *
     * An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of `1`, then when the `base` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of `1` for *capacityProviderA* and a weight of `4` for *capacityProviderB*, then for every one task that's run using *capacityProviderA*, four tasks would use *capacityProviderB*.
     */
    public val weight: kotlin.Int = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.CapacityProviderStrategyItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityProviderStrategyItem(")
        append("base=$base,")
        append("capacityProvider=$capacityProvider,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = base
        result = 31 * result + (capacityProvider.hashCode())
        result = 31 * result + (weight)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityProviderStrategyItem

        if (base != other.base) return false
        if (capacityProvider != other.capacityProvider) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.CapacityProviderStrategyItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The *base* value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a *base* defined. If no value is specified, the default value of `0` is used.
         */
        public var base: kotlin.Int = 0
        /**
         * The short name of the capacity provider.
         */
        public var capacityProvider: kotlin.String? = null
        /**
         * The *weight* value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The `weight` value is taken into consideration after the `base` value, if defined, is satisfied.
         *
         * If no `weight` value is specified, the default value of `0` is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of `0` can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of `0`, any `RunTask` or `CreateService` actions using the capacity provider strategy will fail.
         *
         * An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of `1`, then when the `base` is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of `1` for *capacityProviderA* and a weight of `4` for *capacityProviderB*, then for every one task that's run using *capacityProviderA*, four tasks would use *capacityProviderB*.
         */
        public var weight: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.CapacityProviderStrategyItem) : this() {
            this.base = x.base
            this.capacityProvider = x.capacityProvider
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.CapacityProviderStrategyItem = CapacityProviderStrategyItem(this)

        internal fun correctErrors(): Builder {
            if (capacityProvider == null) capacityProvider = ""
            return this
        }
    }
}
