// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ecs.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartTaskRequest private constructor(builder: Builder) {
    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster where to start your task. If you do not specify a cluster, the default cluster is assumed.
     */
    public val cluster: kotlin.String? = builder.cluster
    /**
     * The container instance IDs or full ARN entries for the container instances where you would like to place your task. You can specify up to 10 container instances.
     */
    public val containerInstances: List<String>? = builder.containerInstances
    /**
     * Specifies whether to use Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
     */
    public val enableEcsManagedTags: kotlin.Boolean? = builder.enableEcsManagedTags
    /**
     * Whether or not the execute command functionality is turned on for the task. If `true`, this turns on the execute command functionality on all containers in the task.
     */
    public val enableExecuteCommand: kotlin.Boolean? = builder.enableExecuteCommand
    /**
     * The name of the task group to associate with the task. The default value is the family name of the task definition (for example, family:my-family-name).
     */
    public val group: kotlin.String? = builder.group
    /**
     * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the `awsvpc` networking mode.
     */
    public val networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = builder.networkConfiguration
    /**
     * A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it receives. You can override the default command for a container (that's specified in the task definition or Docker image) with a `command` override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an `environment` override.
     *
     * A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.
     */
    public val overrides: aws.sdk.kotlin.services.ecs.model.TaskOverride? = builder.overrides
    /**
     * Specifies whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.
     */
    public val propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = builder.propagateTags
    /**
     * The reference ID to use for the task.
     */
    public val referenceId: kotlin.String? = builder.referenceId
    /**
     * An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the `startedBy` parameter. You can then identify which tasks belong to that job by filtering the results of a ListTasks call with the `startedBy` value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.
     *
     * If a task is started by an Amazon ECS service, the `startedBy` parameter contains the deployment ID of the service that starts it.
     */
    public val startedBy: kotlin.String? = builder.startedBy
    /**
     * The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
     *
     * The following basic restrictions apply to tags:
     * + Maximum number of tags per resource - 50
     * + For each resource, each tag key must be unique, and each tag key can have only one value.
     * + Maximum key length - 128 Unicode characters in UTF-8
     * + Maximum value length - 256 Unicode characters in UTF-8
     * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
     * + Tag keys and values are case-sensitive.
     * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The `family` and `revision` (`family:revision`) or full ARN of the task definition to start. If a `revision` isn't specified, the latest `ACTIVE` revision is used.
     */
    public val taskDefinition: kotlin.String? = builder.taskDefinition
    /**
     * The details of the volume that was `configuredAtLaunch`. You can configure the size, volumeType, IOPS, throughput, snapshot and encryption in [TaskManagedEBSVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TaskManagedEBSVolumeConfiguration.html). The `name` of the volume must match the `name` from the task definition.
     */
    public val volumeConfigurations: List<TaskVolumeConfiguration>? = builder.volumeConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ecs.model.StartTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartTaskRequest(")
        append("cluster=$cluster,")
        append("containerInstances=$containerInstances,")
        append("enableEcsManagedTags=$enableEcsManagedTags,")
        append("enableExecuteCommand=$enableExecuteCommand,")
        append("group=$group,")
        append("networkConfiguration=$networkConfiguration,")
        append("overrides=$overrides,")
        append("propagateTags=$propagateTags,")
        append("referenceId=$referenceId,")
        append("startedBy=$startedBy,")
        append("tags=$tags,")
        append("taskDefinition=$taskDefinition,")
        append("volumeConfigurations=$volumeConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cluster?.hashCode() ?: 0
        result = 31 * result + (containerInstances?.hashCode() ?: 0)
        result = 31 * result + (enableEcsManagedTags?.hashCode() ?: 0)
        result = 31 * result + (enableExecuteCommand?.hashCode() ?: 0)
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (networkConfiguration?.hashCode() ?: 0)
        result = 31 * result + (overrides?.hashCode() ?: 0)
        result = 31 * result + (propagateTags?.hashCode() ?: 0)
        result = 31 * result + (referenceId?.hashCode() ?: 0)
        result = 31 * result + (startedBy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taskDefinition?.hashCode() ?: 0)
        result = 31 * result + (volumeConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartTaskRequest

        if (cluster != other.cluster) return false
        if (containerInstances != other.containerInstances) return false
        if (enableEcsManagedTags != other.enableEcsManagedTags) return false
        if (enableExecuteCommand != other.enableExecuteCommand) return false
        if (group != other.group) return false
        if (networkConfiguration != other.networkConfiguration) return false
        if (overrides != other.overrides) return false
        if (propagateTags != other.propagateTags) return false
        if (referenceId != other.referenceId) return false
        if (startedBy != other.startedBy) return false
        if (tags != other.tags) return false
        if (taskDefinition != other.taskDefinition) return false
        if (volumeConfigurations != other.volumeConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ecs.model.StartTaskRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster where to start your task. If you do not specify a cluster, the default cluster is assumed.
         */
        public var cluster: kotlin.String? = null
        /**
         * The container instance IDs or full ARN entries for the container instances where you would like to place your task. You can specify up to 10 container instances.
         */
        public var containerInstances: List<String>? = null
        /**
         * Specifies whether to use Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the *Amazon Elastic Container Service Developer Guide*.
         */
        public var enableEcsManagedTags: kotlin.Boolean? = null
        /**
         * Whether or not the execute command functionality is turned on for the task. If `true`, this turns on the execute command functionality on all containers in the task.
         */
        public var enableExecuteCommand: kotlin.Boolean? = null
        /**
         * The name of the task group to associate with the task. The default value is the family name of the task definition (for example, family:my-family-name).
         */
        public var group: kotlin.String? = null
        /**
         * The VPC subnet and security group configuration for tasks that receive their own elastic network interface by using the `awsvpc` networking mode.
         */
        public var networkConfiguration: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration? = null
        /**
         * A list of container overrides in JSON format that specify the name of a container in the specified task definition and the overrides it receives. You can override the default command for a container (that's specified in the task definition or Docker image) with a `command` override. You can also override existing environment variables (that are specified in the task definition or Docker image) on a container or add new environment variables to it with an `environment` override.
         *
         * A total of 8192 characters are allowed for overrides. This limit includes the JSON formatting characters of the override structure.
         */
        public var overrides: aws.sdk.kotlin.services.ecs.model.TaskOverride? = null
        /**
         * Specifies whether to propagate the tags from the task definition or the service to the task. If no value is specified, the tags aren't propagated.
         */
        public var propagateTags: aws.sdk.kotlin.services.ecs.model.PropagateTags? = null
        /**
         * The reference ID to use for the task.
         */
        public var referenceId: kotlin.String? = null
        /**
         * An optional tag specified when a task is started. For example, if you automatically trigger a task to run a batch process job, you could apply a unique identifier for that job to your task with the `startedBy` parameter. You can then identify which tasks belong to that job by filtering the results of a ListTasks call with the `startedBy` value. Up to 36 letters (uppercase and lowercase), numbers, hyphens (-), and underscores (_) are allowed.
         *
         * If a task is started by an Amazon ECS service, the `startedBy` parameter contains the deployment ID of the service that starts it.
         */
        public var startedBy: kotlin.String? = null
        /**
         * The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define.
         *
         * The following basic restrictions apply to tags:
         * + Maximum number of tags per resource - 50
         * + For each resource, each tag key must be unique, and each tag key can have only one value.
         * + Maximum key length - 128 Unicode characters in UTF-8
         * + Maximum value length - 256 Unicode characters in UTF-8
         * + If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         * + Tag keys and values are case-sensitive.
         * + Do not use `aws:`, `AWS:`, or any upper or lowercase combination of such as a prefix for either keys or values as it is reserved for Amazon Web Services use. You cannot edit or delete tag keys or values with this prefix. Tags with this prefix do not count against your tags per resource limit.
         */
        public var tags: List<Tag>? = null
        /**
         * The `family` and `revision` (`family:revision`) or full ARN of the task definition to start. If a `revision` isn't specified, the latest `ACTIVE` revision is used.
         */
        public var taskDefinition: kotlin.String? = null
        /**
         * The details of the volume that was `configuredAtLaunch`. You can configure the size, volumeType, IOPS, throughput, snapshot and encryption in [TaskManagedEBSVolumeConfiguration](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TaskManagedEBSVolumeConfiguration.html). The `name` of the volume must match the `name` from the task definition.
         */
        public var volumeConfigurations: List<TaskVolumeConfiguration>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ecs.model.StartTaskRequest) : this() {
            this.cluster = x.cluster
            this.containerInstances = x.containerInstances
            this.enableEcsManagedTags = x.enableEcsManagedTags
            this.enableExecuteCommand = x.enableExecuteCommand
            this.group = x.group
            this.networkConfiguration = x.networkConfiguration
            this.overrides = x.overrides
            this.propagateTags = x.propagateTags
            this.referenceId = x.referenceId
            this.startedBy = x.startedBy
            this.tags = x.tags
            this.taskDefinition = x.taskDefinition
            this.volumeConfigurations = x.volumeConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ecs.model.StartTaskRequest = StartTaskRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.NetworkConfiguration] inside the given [block]
         */
        public fun networkConfiguration(block: aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.Builder.() -> kotlin.Unit) {
            this.networkConfiguration = aws.sdk.kotlin.services.ecs.model.NetworkConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ecs.model.TaskOverride] inside the given [block]
         */
        public fun overrides(block: aws.sdk.kotlin.services.ecs.model.TaskOverride.Builder.() -> kotlin.Unit) {
            this.overrides = aws.sdk.kotlin.services.ecs.model.TaskOverride.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
